/***************************************************************************
    Copyright            : (C) 2006 by Tony R. Freeman
    Email                : tony@tonyfreeman.us
    Web                  : http://www.tonyfreeman.us/
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdbool.h>
#include <time.h>

#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>
#include <SDL/SDL_image.h>

#include "SFont.h"
#include "SFont.c"
#include "globals.h"

#ifdef DREAMCAST
#include <kos.h>
#include <SDL/SDL_dreamcast.h>
extern uint8 romdisk[];
KOS_INIT_FLAGS(INIT_DEFAULT | INIT_MALLOCSTATS);
KOS_INIT_ROMDISK(romdisk);
#endif

SFont_Font *ft_menu            = NULL;
SFont_Font *ft_menu_highlight  = NULL;
SFont_Font *ft_main            = NULL;
SFont_Font *ft_help            = NULL;

SDL_Surface *screen            = NULL;
Mix_Music   *music             = NULL;

Mix_Chunk   *mc_sound          = NULL;
Mix_Chunk   *click_on_ball     = NULL;
Mix_Chunk   *illegal_move      = NULL;
Mix_Chunk   *shake_beans       = NULL;
Mix_Chunk   *scatter_beans     = NULL;
Mix_Chunk   *yahoo_red 	       = NULL;
Mix_Chunk   *yahoo_blue        = NULL;
Mix_Chunk   *big_chear 	       = NULL;
Mix_Chunk   *gasp              = NULL;
Mix_Chunk   *god_chuckle       = NULL;
Mix_Chunk   *pay_opponent      = NULL;
Mix_Chunk   *pay_kitty 	       = NULL;
Mix_Chunk   *boom              = NULL;
Mix_Chunk   *wav_click	       = NULL;
Mix_Chunk   *wav_highlight     = NULL;

SDL_Surface *background        = NULL;
SDL_Surface *menu_background   = NULL;

SDL_Surface *red_jade_1	       = NULL;
SDL_Surface *blue_jade_1       = NULL;

SDL_Surface *red_aztec 	       = NULL;
SDL_Surface *blue_aztec        = NULL;

SDL_Surface *money             = NULL;

SDL_Surface *beans[BEAN_COUNT][2];
SDL_Surface *numbers[21];

SDL_Rect src, dest;

char buf[30];

#include "menu.c"
#include "common_functions.c"
#include "video.c"
#include "audio.c"
#include "game_board.c"
#include "pay_opponent.c"
#include "roll_beans.c"
#include "move_jade.c"


int gameLoop()
{
	SDL_Event event;
	Uint8 *keystate;
	Uint8 empty_keys[SDLK_LAST];
	SDLMod modstate = 0;
	
	bool quit = false;
	bool playing = false;
	bool pageOne = true;
	bool pageTwo = true;
	int x = 0;
	int y = 0;
	int buttonstate;
	
	state = STATE_MENU;
	
	memset(empty_keys, 0, sizeof(empty_keys));
	
	while (!quit) {
		// GATHER QUEUED EVENTS AND GET MOUSE/KEYBOARD STATES
		SDL_PumpEvents();
		buttonstate = SDL_GetMouseState(&x, &y);
		keystate = SDL_GetKeyState(0);
		modstate = SDL_GetModState();
		
		if (keystate[SDLK_ESCAPE] || keystate[SDLK_q]) { 
			quit = true; 
		} else if (keystate[SDLK_m]) {
			state = STATE_MENU;
		} else if (keystate[SDLK_n] && state == STATE_HELP) {
			pageOne = false;
			pageTwo = true;
		} else if (keystate[SDLK_b] && state == STATE_HELP) {
			pageOne = true;
			pageTwo = false;
		}

		switch (state) {
			case STATE_MENU:
				playing = false;
				pageOne = true;
				pageTwo = true;
				SDL_BlitSurface( menu_background, 0, screen, 0 );
				menu_draw( &main_menu, screen );
				SDL_Flip(screen);
				if (buttonstate & SDL_BUTTON(1)) {
					switch (menu_handle_click(&main_menu, x, y)) {
					    case ID_QUIT: 
							state = STATE_QUIT;
							break;
					    case ID_HELP:
							page = 1;
							state = STATE_HELP;
							break;
					    case ID_GAME:
							state = STATE_GAME; 
							break;
					}
				} else {
					menu_handle_motion( &main_menu, x, y );
				}
				break;
			case STATE_HELP:
				playing = false;
				if ( keystate[SDLK_ESCAPE] || keystate[SDLK_q] ) { state = STATE_MENU; }
				SDL_BlitSurface( menu_background, 0, screen, 0 );
				if (pageOne == true) {
					pageTwo = false;
					draw_help();
					menu_draw( &help_menu_one, screen );
					SDL_Flip(screen); 
					if (buttonstate & SDL_BUTTON(1)) {
						switch (menu_handle_click(&help_menu_one, x, y)) {
							case ID_MENU: 
								state = STATE_MENU;
								break;
							case ID_NEXT:
								pageOne = false;
								pageTwo = true;
								state = STATE_HELP;
								break;
							case ID_BACK:
								pageOne = true;
								pageTwo = false;
								state = STATE_HELP; 
								break;
						}
					} else {
						menu_handle_motion( &help_menu_one, x, y );
					}
				} else {
					pageOne = false;
					draw_help_two();
					menu_draw( &help_menu_two, screen );
					SDL_Flip(screen); 
					if (buttonstate & SDL_BUTTON(1)) {
						switch (menu_handle_click(&help_menu_two, x, y)) {
							case ID_MENU: 
								state = STATE_MENU;
								break;
							case ID_NEXT:
								pageOne = false;
								pageTwo = true;
								state = STATE_HELP;
								break;
							case ID_BACK:
								pageOne = true;
								pageTwo = false;
								state = STATE_HELP; 
								break;
						}
					} else {
						menu_handle_motion( &help_menu_two, x, y );
					}
				}
				break;
			case STATE_GAME:
				pageOne = true;
				pageTwo = true;
				if (!playing) {
					refresh_screen();
					if (winner == -1) {
						printf("GAME STATE: sending true \n");
						resetGameBoard(true);
					} else {
						printf("GAME STATE: sending false \n");
						resetGameBoard(false);
					}
					playing = true;
				}
			        // THE AZTEC PRIEST SHOWS RED FOR RED'S TURN
				// OR BLUE FOR BLUE'S TURN
				showAztec(player);
				// SHAKE THE BEANS AND ROLL
				roll_the_beans();
				// CHECK TO SEE IF SOMEONE HAS FINISHED THE GAME
				if (is_game_finished()) { 
					playing = false;
					state = GAME_OVER; 
				}
				// MAKE YOUR MOVE
				make_move();
				// CHECK TO SEE IF SOMEONE HAS FINISHED THE GAME
				if (is_game_finished()) { 
					playing = false;
					state = GAME_OVER; 
				}
				// SWITCH PLAYERS
				player = (player == RED) ? BLUE : RED;
				break;
			case NEW_ROUND:
				printf("GOING INTO NEW ROUND STATE!\n");
				printf("Winner: %d \n", winner);
				playing = false;
				pageOne = true;
				pageTwo = true;
				// THE GAME ISN'T OVER UNTIL SOMEONE HAS ALL THE MONEY
				// RESET THE GAME BOARD FOR A NEW ROUND
				SDL_BlitSurface( menu_background, 0, screen, 0 );
				draw_new_round_comment();
				SDL_Flip(screen);
				SDL_Delay(7000);
				// THE MONEY STAYS THE SAME BUT THE JADES NEED TO BE RESET
				printf("NEW ROUND: sending false \n");
				resetGameBoard(false);
				state = STATE_GAME;
				break;
			case STATE_QUIT:
				playing = false;
				pageOne = true;
				pageTwo = true;
				quit = true;
				break;
			case GAME_OVER:
				sprintf( buf, "%s Won The GAME!", winningPlayer );
				playing = false;
				pageOne = true;
				pageTwo = true;
				SDL_BlitSurface( menu_background, 0, screen, 0 );
				SFont_Write(screen,ft_menu_highlight,350 - (SFont_TextWidth(ft_menu_highlight,buf)/2),130,buf);
				SFont_Write(screen,ft_menu_highlight,350 - (SFont_TextWidth(ft_menu_highlight,"Play again?")/2),155,"Play again?");
				menu_draw( &yesno_menu, screen );
				SDL_Flip(screen);
				if (buttonstate & SDL_BUTTON(1)) {
					switch (menu_handle_click(&yesno_menu, x, y)) {
						case ID_QUIT: 
							quit = true;
							break;
						case ID_GAME:
							pageOne = true;
							pageTwo = false;
							state = STATE_GAME;
							break;
					}
				} else {
						menu_handle_motion(&yesno_menu, x, y);
				}
				break;
		}
		// CLOSE THE GAME IF USER PRESSES ESCAPE OR THE Z KEY
		if (event.key.keysym.sym == SDLK_ESCAPE || event.key.keysym.sym == SDLK_z) { quit = true; }
		// GO TO THE GAME MENU IF THE USER PRESSES "q"
		if (event.key.keysym.sym == SDLK_q) { quit = true; }
	}
	return EXIT_SUCCESS;
}


int main(int argc, char **argv)
{
	printf("Starting...\n");
	atexit(SDL_Quit);
	
	//INIT SDL
	if (SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO|SDL_INIT_JOYSTICK) != 0) {
		fprintf(stderr, "Error: unable to initialize SDL: %s\n", SDL_GetError());
		return EXIT_FAILURE;
	}

	setupVideo();
	loadGameImages();
	//Dreamcast pad
	#ifdef DREAMCAST
	SDL_DC_MapKey(0,SDL_DC_START,SDLK_q);
	SDL_DC_MapKey(0,SDL_DC_A,SDLK_n);
	SDL_DC_MapKey(0,SDL_DC_B,SDLK_b);
	SDL_DC_MapKey(0,SDL_DC_R,SDLK_ESCAPE); //L button
	SDL_DC_MapKey(0,SDL_DC_L,SDLK_m); //L button
	
	SDL_JoystickEventState(SDL_ENABLE);
	SDL_JoystickOpen(0); 	
	SDL_DC_EmulateMouse(1);
	
	//Dreamcast delay...
	SDL_Delay(50);
	SDL_Event event;
	while(SDL_PollEvent(&event))
		SDL_Delay(20);
	#endif
	setupAudio();
	setupMenus();
	gameLoop();
	
	shutdownAudio();
	unloadGameImages();
	
	SDL_Quit();
	
	return EXIT_SUCCESS;
}
