/***************************************************************************
    Copyright            : (C) 2006 by Tony R. Freeman
    Email                : tony@tonyfreeman.us
    Web                  : http://www.tonyfreeman.us/
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

int loadGameImages()
{
	int i = 0; // FOR BEAN IMAGES
	int j = 0; // FOR BEAN IMAGES
	
	for (i = 0; i < BEAN_COUNT; i++) {
		for (j = 0; j < 2; j++) {
			beans[i][j] = IMG_Load(beanFilenames[i * 2 + j]);
			if (beans[i][j] == NULL) { 
				fprintf(stderr, "Unable to load '%s': %s\n", beanFilenames[i * 2 + j], SDL_GetError());
				return 0; 
			}
		}
	}
	
	// LOAD THE NUMBERS INTO MEMORY
	for (i = 0; i<21; i++) {
		numbers[i] = IMG_Load(numbersFilenames[i]);
	}
	
	// DREAMCAST PATHS ROMDISK
	// LOAD JADE IMAGES INTO MEMORY
	red_jade_1 = IMG_Load("/rd/images/red_jade_1.png");
	if (red_jade_1 == NULL) { 
		fprintf(stderr, "Unable to load 'red_jade_1': %s\n", SDL_GetError()); 
		return 0; 
	}
	
	blue_jade_1 = IMG_Load("/rd/images/blue_jade_1.png");
	if (blue_jade_1 == NULL) { 
		fprintf(stderr, "Unable to load 'blue_jade_1': %s\n", SDL_GetError()); 
		return 0; 
	}
	
	// LOAD AZTEC IMAGES INTO MEMORY
	red_aztec = IMG_Load("/rd/images/aztec-red.png");
	if (red_aztec == NULL) { 
		fprintf(stderr, "Unable to load 'red_aztec': %s\n", SDL_GetError()); 
		return 0; 
	}
	
	blue_aztec = IMG_Load("/rd/images/aztec-blue.png");
	if (blue_aztec == NULL) { 
		fprintf(stderr, "Unable to load 'blue_aztec': %s\n", SDL_GetError()); 
		return 0; 
	}
	
	// LOAD OTHER IMAGES INTO MEMORY
	money = IMG_Load("/rd/images/money.png");
	if (money == NULL) { 
		fprintf(stderr, "Unable to load 'money'. %s\n", SDL_GetError()); 
		return 0; 
	}
	
	// LOAD FONTS
	ft_main = SFont_InitFont(IMG_Load("/rd/fonts/24P_Copperplate_Main.png"));
	if (!ft_main) { 
		fprintf(stderr, "Unable to load 'ft_main': %s\n", SDL_GetError()); 
		return 0; 
	}
	
	ft_menu = SFont_InitFont(IMG_Load("/rd/fonts/24P_Copperplate_Menu.png"));
	if (!ft_menu) { 
		fprintf(stderr, "Unable to load 'ft_menu': %s\n", SDL_GetError()); 
		return 0; 
	}
	
	ft_menu_highlight = SFont_InitFont(IMG_Load("/rd/fonts/24P_Copperplate_Menu_Highlight.png"));
	if (!ft_menu_highlight) { 
		fprintf(stderr, "Unable to load 'ft_menu_highlight': %s\n", SDL_GetError()); 
		return 0; 
	}
	
	ft_help = SFont_InitFont(IMG_Load("/rd/fonts/fontHelp240.png"));
	if (!ft_help) { 
		fprintf(stderr, "Unable to load 'ft_help': %s\n", SDL_GetError()); 
		return 0; 
	}
	
	return EXIT_SUCCESS;
}


void unloadGameImages()
{
	int i = 0;
	int j = 0;
	// FREE THE FONT IMAGES
	SFont_FreeFont(ft_main);
	SFont_FreeFont(ft_menu);
	SFont_FreeFont(ft_menu_highlight);
	SFont_FreeFont(ft_help);
	// FREE THE BEAN IMAGES
	for (i = 0; i < BEAN_COUNT; i++) {
		for (j = 0; j < 2; j++) {
			SDL_FreeSurface(beans[i][j]);
		}
	}
	// FREE THE NUMBERS IMAGES
	for (i = 0; i<=21; i++) {
		SDL_FreeSurface(numbers[i]);
	}
	// FREE ALL THE OTHER IMAGES
	SDL_FreeSurface(red_jade_1);
	SDL_FreeSurface(blue_jade_1);
	SDL_FreeSurface(red_aztec);
	SDL_FreeSurface(blue_aztec);
	SDL_FreeSurface(background);
}


void show_red_home_jades (int x, int y)
{
	dest.x = x - red_jade_1->w / 2;
	dest.y = y - red_jade_1->h / 2;
	dest.w = red_jade_1->w;
	dest.h = red_jade_1->h;
	SDL_BlitSurface(red_jade_1, NULL, screen, &dest);
}


void show_blue_home_jades (int x, int y)
{
	dest.x = x - blue_jade_1->w / 2;
	dest.y = y - blue_jade_1->h / 2;
	dest.w = blue_jade_1->w;
	dest.h = blue_jade_1->h;
	SDL_BlitSurface(blue_jade_1, NULL, screen, &dest);
}


void hideAztec(int thePlayer)
{
	// BOTH RED AND BLUE AZTEC IMAGES ARE THE SAME DIMENSIONS
	// SO I'LL JUST USE THE INFORMATION FROM THE RED FOR BOTH
	src.x = 316 - (red_aztec->w / 2);
	src.y =  64 - (red_aztec->h / 2);
	src.w = red_aztec->w;
	src.h = red_aztec->h;
	dest = src;
	SDL_BlitSurface(background, &src, screen, &dest);
}


void showAztec(int thePlayer)
{
	// FIRST HIDE THE AZTEC
	hideAztec(thePlayer);
	// NOW SHOW THE CORRECT ONE
	if (thePlayer == RED) {
		dest.x = 316 - (red_aztec->w / 2);
		dest.y =  64 - (red_aztec->h / 2);
		dest.w = red_aztec->w;
		dest.h = red_aztec->h;
		SDL_BlitSurface(red_aztec, NULL, screen, &dest);
	} else {
		dest.x = 316 - (blue_aztec->w / 2);
		dest.y =  64 - (blue_aztec->h / 2);
		dest.w = blue_aztec->w;
		dest.h = blue_aztec->h;
		SDL_BlitSurface(blue_aztec, NULL, screen, &dest);
	}
	SDL_UpdateRect(screen, 0, 0, 0, 0);
}


int setupGameBoard()
{
	int i = 0;
	// PLACE RED AND BLUE JADE IMAGES IN STARTING POSITIONS
	for (i=0; i<JADE_COUNT; i++) {
		 show_red_home_jades( RedHomePositions[i][0],  RedHomePositions[i][1]);
		show_blue_home_jades(BlueHomePositions[i][0], BlueHomePositions[i][1]);
	}
	// PLACE THE NUMBERS IMAGES IN THE TALLY AREAS
	update_totals();
	// RED GOES FIRST, SO PUT RED AZTEC PRIEST ON BOARD
	showAztec(RED);
	SDL_UpdateRect(screen, 0, 0, 0, 0);
	return EXIT_SUCCESS;
}


void resetGameBoard(bool kitty)
{
	int i=0;
	for (i=0; i < JADE_COUNT; i++) {
		JadePositions[i][0] = -1;
		JadePositions[i][1] = -1;
	}
	if (kitty == true) {
		printf("I'm printing true for kitty\n");
		theMoney[0] = 10;
		theMoney[1] = 10;
		theMoney[2] = 0;
		winner = -1;
	} else {
		winner = 0;
	}
	bean_count    = 0;
	winningPlayer = "Nobody";
	gameOver = false;
	gameReallyOver = false;
	selected_blue_jade = JADE_COUNT + 1;
	for (i=0; i < BEAN_COUNT; i++) {
		theBeans[i][0] = 0;
	}
	SDL_BlitSurface(background, NULL, screen, NULL);
	SDL_Flip(screen);
	setupGameBoard();
}
