/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#ifndef		GAME_H
#define		GAME_H

#include <kos.h>
#include <dcalleg.h>
#include <allegro.h>
#include "board.h"
#include "pad.h"
#include "player.h"
#include "dart.h"
#include "scoreboard.h"
#include "mainmenu.h"
#include "error.h"

class Game {
	private:
		BITMAP *buffer;
		BITMAP *holder;
		Board *board;
		Pad *pad;
		ScoreBoard *scoreBoard;
		Player *player[2];
		Dart dart[3];
		int lastScore, total;
		int throwing;
		int activePlayer;
		int counter;
		bool menuOn;
		MainMenu menu;
	
		void Draw();
		bool Update();
		void DrawDoubleBuffer();
		void DrawMouse();
		void DrawScore();
		void DrawDarts();
		void ResetDarts();
		void GameOver();
		void RestartGame();
	
	public:
		Game();
		~Game();
		Error Init();
		void Run();
};

#endif		//GAME_H
