/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#include "error.h"
#include <kos.h>
#include <dcalleg.h>
#include <allegro.h>


const char *errorDescription[] = {
	"No error.\n",
	"Error initializing Allegro!\n",
	"Error installing keyboard module!\n",
	"Error installing mouse module!\n",
	"Error installing timer module!\n",
	"Error initializing graphics mode!\n",
	"Error installing sound module!\n",
	"Ran out of memory!!!\n"
};


Error::Error(Type t)
	:type(t)
{
}


const char *Error::GetDescription() {
	return errorDescription[type];
}


Error::operator bool() const {
	return !(type == NONE);
}


bool Error::operator==(const Type  &t) {
	return (type == t);
}
