/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#include "scoreboard.h"

ScoreBoard::ScoreBoard(int x, int y) : Object(x, y) {
	sc1 = load_bitmap("/rd/score1.tga", NULL);
	sc2 = load_bitmap("/rd/score2.tga", NULL);
	font = load_bitmap("/rd/numbers.tga", NULL);
}


ScoreBoard::~ScoreBoard() {
	destroy_bitmap(sc1);
	destroy_bitmap(sc2);
	destroy_bitmap(font);
}


void ScoreBoard::Draw(BITMAP *buffer, int activePlayer, int p1s, int p2s, int lastScore, int total) {
	int x = (int)(this->x);
	int y = (int)(this->y);
	int w = sc1->w/2;
	int h = sc1->h/4;
	
	// the active player display
	blit(activePlayer == 0 ? sc2 : sc1, buffer, 0, 0, x, y, w, h);
	blit(activePlayer == 1 ? sc2 : sc1, buffer, w, 0, x+w, y, w, h);
	
	// the scores
	blit(sc1, buffer, 0, h, x, y+h, 2*w, h);
	DrawNumber(buffer, p1s, x+6, y+h+4);
	DrawNumber(buffer, lastScore, x+6+w/2, y+h+4);
	DrawNumber(buffer, total, x+6+w, y+h+4);
	DrawNumber(buffer, p2s, x+6+3*w/2, y+h+4);
	
	// the selected game
	int game = 0;
	switch (Params::maxPoints) {
		case 301:	game = 0;	break;
		case 501:	game = 1;	break;
		case 701:	game = 2;	break;
		case 901:	game = 3;	break;
	}
	for (int i=0; i<4; ++i) {
		blit(i==game ? sc2 : sc1, buffer, i*w/2, 2*h, x+i*w/2, y+2*h, w/2, h);
	}
	
	// game type
	blit(Params::doubleIn == 1 ? sc2 : sc1, buffer, 0, 3*h, x, y+3*h, w, h);
	blit(Params::doubleOut == 1 ? sc2 : sc1, buffer, w, 3*h, x+w, y+3*h, w, h);
}


void ScoreBoard::DrawNumber(BITMAP *buffer, int n, int x, int y) {
	int w = font->w/10;
	int h = font->h;
	int d;
	
	d = n/100;
	masked_blit(font, buffer, d*w, 0, x, y, w, h);
	
	d = (n/10)%10;
	masked_blit(font, buffer, d*w, 0, x+w+1, y, w, h);
	
	d = n%10;
	masked_blit(font, buffer, d*w, 0, x+2*(w+1), y, w, h);
}
