/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#include <kos.h>
#include <dcalleg.h>
#include <allegro.h>
#include "params.h"


int Params::w = 640;
int Params::h = 480;
int Params::bpp = 32;
int Params::fullscreen = 0;
int Params::fps = 50;
int Params::rim[6];
int Params::difficulty = 2;
int Params::maxPoints = 501;
int Params::doubleIn = 0;
int Params::doubleOut = 0;


void Params::Load(const char *file) {
	set_config_file(file);
	
	w = get_config_int("GENERAL", "w", w);
	h = get_config_int("GENERAL", "h", h);
	bpp = get_config_int("GENERAL", "bpp", bpp);
	fullscreen = get_config_int("GENERAL", "fullscreen", fullscreen);
	fps = get_config_int("GENERAL", "fps", fps);
	difficulty = get_config_int("GAME", "difficulty", difficulty);
	maxPoints = get_config_int("GAME", "maxPoints", maxPoints);
	doubleIn = get_config_int("GAME", "doubleIn", doubleIn);
	doubleOut = get_config_int("GAME", "doubleOut", doubleOut);
	
	rim[0] = 3;
	rim[1] = 7;
	rim[2] = 48;
	rim[3] = 53;
	rim[4] = 88;
	rim[5] = 93;

	char *name[] = { "rim1", "rim2", "rim3", "rim4", "rim5", "rim6" };
	for (int i=0; i<6; ++i) {
		rim[i] = get_config_int("BOARD", name[i], rim[i]);
	}
}


void Params::Save(const char *file) {
	set_config_file(file);
	
	set_config_int("GENERAL", "w", w);
	set_config_int("GENERAL", "h", h);
	set_config_int("GENERAL", "bpp", bpp);
	set_config_int("GENERAL", "fps", fps);
	set_config_int("GENERAL", "fullscreen", fullscreen);
	set_config_int("GAME", "difficulty", difficulty);
	set_config_int("GAME", "maxPoints", maxPoints);
	set_config_int("GAME", "doubleIn", doubleIn);
	set_config_int("GAME", "doubleOut", doubleOut);

	char *name[] = { "rim1", "rim2", "rim3", "rim4", "rim5", "rim6" };
	for (int i=0; i<6; ++i) {
		set_config_int("BOARD", name[i], rim[i]);
	}
	
	flush_config_file();
}
