/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#include "pad.h"


Pad::Pad(int x, int y, int size_) : Object(x, y), size(size_) {
	back = load_bitmap("/rd/pad.tga", NULL);
	if (!back) {
		back = create_bitmap(160, 160);
		clear_to_color(back, makecol(128,128,128));
	}
}


Pad::~Pad() {
	destroy_bitmap(back);
}


void Pad::Draw(BITMAP *buffer) {
	stretch_blit(back, buffer, 0, 0, back->w, back->h, (int)x, (int)y, size, size);
}


bool Pad::GetMousePos(int &x2, int &y2) {
	int mx = mouse_x - (int)x;
	int my = mouse_y - (int)y;
	if (mx > size || my > size) {
		x2 = 0;
		y2 = 0;
		return false;
	}
	
	x2 = mx*SCREEN_H/size;
	y2 = my*SCREEN_H/size;
	
	return mouse_b ? false : true;
}


bool Pad::CanThrow() {
	return (mouse_x >= (int)x && mouse_y >= (int)y + size);
}
