/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#ifndef		MENUITEM_H
#define		MENUITEM_H

#include <kos.h>
#include <dcalleg.h>
#include <allegro.h>
#include "object.h"
#include <vector>
#include <string>
using namespace std;

class MenuItem : public Object {
	protected:
		string text;
		vector<string> options;
		int sel;
		bool exit;
		bool selected;
		float startx, starty;
		float vx, vy;
		float maxvx, maxvy;
		bool goingUpx, goingUpy;
	
	public:
		MenuItem(int x, int y, const string &text, const vector<string> &options, int sel, bool exit=false);
		~MenuItem();

		void Draw(BITMAP *buffer);
		void OnClick();
		bool WillExit() { return exit; }
		bool Select(bool sel=true) { selected = sel; }
		int Selection() { return sel; }
		
		void Update();
};

#endif		//MENUITEM_H
