/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#ifndef		MENU_H
#define		MENU_H

#include "menuitem.h"

class Menu {
	protected:
		vector<MenuItem> item;
		int sel;
		bool done;
		bool exit;
		int x, y, w, h;

		virtual void OnExit();
	
	public:
		Menu();
		virtual ~Menu();

		virtual void Draw(BITMAP *buffer);
		virtual void OnKey(int c);
		void Add(const MenuItem &mi);
		bool Done() { return done; }
		bool WillExit() { return exit; }
		void Reset();
		int Selection() { return sel; }
		void Update();
};

#endif		//MENU_H
