/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#include "dart.h"


BITMAP *Dart::sprite = NULL;
int Dart::size = 8;

Dart::Dart() : Object(0.0f, 0.0f), angle(0) {}

	
Dart::~Dart() {}

	
void Dart::Draw(BITMAP *buffer) {
	//rotate_sprite(buffer, sprite, (int)x - size, (int)y - size, itofix(angle));
	pivot_sprite(buffer, sprite, (int)x, (int)y, sprite->w>>1, sprite->h>>1, itofix(angle));
}


void Dart::Move(int xx, int yy) {
	angle += abs((int)(yy - y));
	angle %= 256;
	x = xx;
	y = yy;
}


void Dart::InitDefaultPosition(int xx, int yy) {
	defx = xx;
	defy = yy;
}


void Dart::Reset() {
	Move(defx, defy);
}


int Dart::Load() {
	sprite = load_bitmap("/rd/dart.tga", NULL);
	if (!sprite) {
		sprite = create_bitmap(2*size, 2*size);
		clear_to_color(sprite, makecol(255,0,255));
		line(sprite, 0, 0, sprite->w-1, sprite->h-1, makecol(0,255,255));
		line(sprite, 0, sprite->h-1, sprite->w-1, 0, makecol(0,255,255));
	}
	else {
		size = sprite->w / 2;
	}
	
	if (!sprite)
		return -1;
	else
		return 0;
}


void Dart::Destroy() {
	destroy_bitmap(sprite);
	sprite = NULL;
}
