/********************************************************************
 *                        AllegroDarts v1.02                         *
 *                               by                                 *
 *               Miran Amon (miran_amon@hotmail.com)                *
 *                  copyright (c) Miran Amon 2003                   *
 ********************************************************************/

#include "board.h"
#include <math.h>
#include "params.h"
#include "sounds.h"


Board::Board(int size) : Object(0.0f, 0.0f) {
	board = create_bitmap(size, size);
	bmp = load_bitmap("/rd/board.tga", NULL);
	mark = load_bitmap("/rd/mark.tga", NULL);
	if (!mark) {
		mark = create_bitmap(11,11);
		clear_to_color(mark, makecol(255,0,255));
		circlefill(mark, 5,5,5, makecol(0,255,0));
	}
	for (int i=0; i<6; ++i) {
		rim[i] = Params::rim[i];
	}
	DrawBoard();
}


Board::~Board() {
	destroy_bitmap(board);
	if (bmp) destroy_bitmap(bmp);
	destroy_bitmap(mark);
}


void Board::Draw(BITMAP *buffer) {
	blit(board, buffer, 0, 0, (int)x, (int)y, board->w, board->h);
}


inline float FRAC(float x, int p) { return p*x/100.0f; }
inline float RAD(float x) { return x*3.14159f/180.0f; }
inline float DEG(float x) { return x*180.0f/3.14159f; }

void Board::GetPoint(float a, float r, int p, float &x2, float &y2) {
	x2 = (r + FRAC(r,p) * cos(RAD(a)));
	y2 = (r + FRAC(r,p) * sin(RAD(a)));
}

void Board::DrawBoard() {
	if (bmp) {
		stretch_blit(bmp, board, 0, 0, bmp->w, bmp->h, 0, 0, board->w, board->h);
		return;
	}
	
	clear_to_color(board, makecol(0,16,32));
	int w = board->w-1;
	int h = board->h-1;
	int r = (board->w)>>1;
	
	int black = makecol(0,0,0);
	int red = makecol(255,0,0);
	int yellow = makecol(255,255,0);
	int white = makecol(255,255,255);

	circlefill(board, r, r, r, black);
	
	float da = 18;
	float alpha = 9;
	float x2, y2;
	for (int i=0; i<20; ++i) {
		GetPoint(alpha, r, rim[5]+2, x2, y2);
		alpha += da;
		line(board, r, r, (int)x2, (int)y2, yellow);
	}

	circlefill(board, r, r, (int)FRAC(r, rim[1]), yellow);
	circlefill(board, r, r, (int)FRAC(r, rim[1]-1), red);
	circlefill(board, r, r, (int)FRAC(r, rim[0]), black);
	circle(board, r, r, (int)FRAC(r, rim[2]), yellow);
	circle(board, r, r, (int)FRAC(r, rim[3]), yellow);
	circle(board, r, r, (int)FRAC(r, rim[4]), yellow);
	circle(board, r, r, (int)FRAC(r, rim[5]), yellow);
	
	int numbers[] = { 6,10,15,2,17,3,19,7,16,8,11,14,9,12,5,20,1,18,4,13 };
	da = 18;
	alpha = 0;
	text_mode(-1);
	for (int i=0; i<20; ++i) {
		GetPoint(alpha, r, rim[5]+3, x2, y2);
		y2 -= text_height(font)/2.0f;
		alpha += da;
		textprintf_centre(board, font, (int)x2, (int)y2, white, "%d", numbers[i]);
		
		GetPoint(alpha, r, (rim[1]+rim[2])>>1, x2, y2);
		floodfill(board, (int)x2, (int)y2, i%2 ? black: red);
		GetPoint(alpha, r, (rim[2]+rim[3])>>1, x2, y2);
		floodfill(board, (int)x2, (int)y2, i%2 ? red: black);
		GetPoint(alpha, r, (rim[3]+rim[4])>>1, x2, y2);
		floodfill(board, (int)x2, (int)y2, i%2 ? black: red);
		GetPoint(alpha, r, (rim[4]+rim[5])>>1, x2, y2);
		floodfill(board, (int)x2, (int)y2, i%2 ? red :black);
	}
}


int Board::GetPoints(int mx, int my, int &f) {
	int r = (board->w)>>1;
	
	int d = (int)sqrt((mx - r)*(mx - r) + (my - r)*(my - r));
	d *= 100;
	d /= r;
	
	f = 1;
	int smp = SMP_HIT;
	Sound::Play(SMP_HIT, 1000 + (rand()%50-25));
	if (d < rim[0]) {
		Sound::Play(SMP_50);
		MarkHit(mx, my);
		return 50;
	}
	else if (d < rim[1]) {
		Sound::Play(SMP_25);
		MarkHit(mx, my);
		return 25;
	}
	else if (d >= rim[2] && d < rim[3]) {
		smp = SMP_TRIPLE;
		f = 3;
	}
	else if (d >= rim[4] && d < rim[5]) {
		smp = SMP_DOUBLE;
		f = 2;
	}
	else if (d >= rim[5]) {
		Sound::Play(SMP_HIT, 1000 + (rand()%50-25));
		MarkHit(mx, my);
		return 0;
	}
	
	if (smp != SMP_HIT) {
		Sound::Play(smp);
	}
	MarkHit(mx, my);
	int numbers[] = { 6,10,15,2,17,3,19,7,16,8,11,14,9,12,5,20,1,18,4,13,6 };
	mx -= r;
	my -= r;
	if (mx == 0) mx = 1;
	float fmx = mx == 0 ? 0.0001f : (float)mx;
	float fmy = my == 0 ? 0.0001f : (float)my;
	float a = DEG(atan(ABS(fmy/fmx)));
	if (fmx < 0.0f && fmy > 0.0f) {
		a = 180.0f - a;
	}
	else if (fmx < 0.0f && fmy < 0.0f) {
		a += 180.0f;
	}
	else if (fmx > 0.0f && fmy < 0.0f) {
		a = 360.0f - a;
	}
	a += 9.0f;
	a /= 18.0f;
	return numbers[(int)a]*f;
}


void Board::MarkHit(int mx, int my) {
	draw_sprite(board, mark, mx-mark->w/2, my-mark->h/2);
}
