/*
    This file is part of Dream Photo Manager.

    Copyright (C) 2009 Lawrence Sebald

    Dream Photo Manager is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 
    as published by the Free Software Foundation.

    Dream Photo Manager is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Dream Photo Manager; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef IMGUTILS_H
#define IMGUTILS_H

#include <dc/pvr.h>
#include <dc/maple.h>

int grab_all_images(maple_device_t *dev, void (*cb)(int, int));
void release_all_images(void);

int load_texture(int num, float *u, float *v, pvr_poly_ic_hdr_t *dst);
int erase_image(int num, maple_device_t *dev);

int get_image_count(void);

#endif /* !IMGUTILS_H */
