/*
    This file is part of Dream Photo Manager.

    Copyright (C) 2007, 2009 Lawrence Sebald

    Dream Photo Manager is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 
    as published by the Free Software Foundation.

    Dream Photo Manager is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Dream Photo Manager; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/* This file was imported from CrabEmu. */

#ifndef FONT_H
#define FONT_H

#include <dc/pvr.h>

#define FONT_CHAR_WIDTH     12
#define FONT_CHAR_HEIGHT    24
#define FONT_LINE_HEIGHT    26

pvr_ptr_t font_load_txr();
void font_draw_char(char c, pvr_ptr_t font, int x, int y, int z);
void font_draw_str(const char *c, pvr_ptr_t font, int x, int y, int z);
void font_draw_str_centered(const char *str, pvr_ptr_t font, int xmin, int xmax,
                            int y, int z);

#endif /* !FONT_H */
