/*
    This file is part of Dream Photo Manager.

    Copyright (C) 2009 Lawrence Sebald

    Dream Photo Manager is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 
    as published by the Free Software Foundation.

    Dream Photo Manager is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Dream Photo Manager; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef PVRUTILS_H
#define PVRUTILS_H

#include <dc/pvr.h>
#include <kos/img.h>

pvr_ptr_t create_texture(kos_img_t *kmg, int *w, int *h);
void draw_fullscreen_sprite(float umax, float vmax);

void draw_colored_quad(uint32 list, float x, float y, float z, float w, float h,
                       uint32 color);

void draw_dialog_centered(const char *str, float xmin, float xmax, float ymin,
                          float ymax, float z, uint32 color, pvr_ptr_t f);

#endif /* !PVRUTILS_H */
