#include "global.h"

#include <kos.h>

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_mixer.h>
#include <SDL/SDL_dreamcast.h>

extern uint8 romdisk[];
KOS_INIT_ROMDISK(romdisk);

#define FOND_TRANSPARENT_B(i) SDL_SetColorKey(b[i], SDL_SRCCOLORKEY, SDL_MapRGB(b[i]->format, 255, 255, 255));
#define FOND_TRANSPARENT_N(i) SDL_SetColorKey(n[i], SDL_SRCCOLORKEY, SDL_MapRGB(n[i]->format, 255, 255, 255));

SDL_Joystick *joystick;

void quitter(){
//	SDL_Quit();
}

/* Initialise SDL */
void initialisation(SDL_Surface **ecran){

	/* Initialisation SDL */
	if(SDL_Init(SDL_INIT_VIDEO|SDL_INIT_JOYSTICK) < 0){
		fprintf(stderr, "Erreur d'initialisation de la SDL : %s\n", SDL_GetError());
		exit(EXIT_FAILURE);
	}
	
    /* Appel de la fonction quitter lors de l'interruption de l'application */
	atexit(quitter);

	/* Ajout d'un icone */
//	SDL_WM_SetIcon(IMG_Load("/rd/icone.png"), NULL);
	
	/* Cration de la fentre */
	if((*ecran = SDL_SetVideoMode(640, 480, 16, SDL_SWSURFACE|SDL_DOUBLEBUF)) == NULL){
		fprintf(stderr, "Erreur SDL: %s\n", SDL_GetError());
		exit(EXIT_FAILURE);
	}
	
	//Dreamcast controls!
	SDL_DC_MapKey(0,SDL_DC_START,SDLK_n); 
	SDL_DC_MapKey(0,SDL_DC_UP,SDLK_UP); 
	SDL_DC_MapKey(0,SDL_DC_DOWN,SDLK_DOWN); 
	SDL_DC_MapKey(0,SDL_DC_R,SDLK_ESCAPE); //L button
	
	SDL_JoystickEventState(SDL_ENABLE);
	SDL_JoystickOpen(0); 	
	SDL_ShowCursor(1);
	
	//Dreamcast delay...
	SDL_Event event;
	while(SDL_PollEvent(&event))
		SDL_Delay(20);
	
	/* Ajout du titre */
//	SDL_WM_SetCaption("SudokuDC by Ron", NULL);
	
	srand(SDL_GetTicks());
}

/* Cette fonction charge l'ensemble des chiffres */
void chargement_chiffres(SDL_Surface *b[9], SDL_Surface *n[9]){

	/* Chargement des chiffres de couleur bleu*/
	b[0] = IMG_Load("/rd/b1.png"); FOND_TRANSPARENT_B(0);	
	b[1] = IMG_Load("/rd/b2.png"); FOND_TRANSPARENT_B(1);	
	b[2] = IMG_Load("/rd/b3.png"); FOND_TRANSPARENT_B(2);
	b[3] = IMG_Load("/rd/b4.png"); FOND_TRANSPARENT_B(3);
	b[4] = IMG_Load("/rd/b5.png"); FOND_TRANSPARENT_B(4);
	b[5] = IMG_Load("/rd/b6.png"); FOND_TRANSPARENT_B(5);
	b[6] = IMG_Load("/rd/b7.png"); FOND_TRANSPARENT_B(6);
	b[7] = IMG_Load("/rd/b8.png"); FOND_TRANSPARENT_B(7);
	b[8] = IMG_Load("/rd/b9.png"); FOND_TRANSPARENT_B(8);

	/* Chargement des chiffres de couleur noir */
	n[0] = IMG_Load("/rd/n1.png"); FOND_TRANSPARENT_N(0);
	n[1] = IMG_Load("/rd/n2.png"); FOND_TRANSPARENT_N(1);
	n[2] = IMG_Load("/rd/n3.png"); FOND_TRANSPARENT_N(2);	
	n[3] = IMG_Load("/rd/n4.png"); FOND_TRANSPARENT_N(3);
	n[4] = IMG_Load("/rd/n5.png"); FOND_TRANSPARENT_N(4);
	n[5] = IMG_Load("/rd/n6.png"); FOND_TRANSPARENT_N(5);
	n[6] = IMG_Load("/rd/n7.png"); FOND_TRANSPARENT_N(6);	
	n[7] = IMG_Load("/rd/n8.png"); FOND_TRANSPARENT_N(7);
	n[8] = IMG_Load("/rd/n9.png"); FOND_TRANSPARENT_N(8);;
}
