#include "global.h"
#include <stdio.h>

#include <kos.h>

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_mixer.h>
#include <SDL/SDL_dreamcast.h>

/* Fonction permettant de savoir si la grille est correcte */
int verification_grille(int grille[9][9], int grille_complete[9][9]){
	int i, j;
	
	for(i = 0; i < 9; i++){
		for(j = 0; j < 9; j++){
			if(grille[i][j] != grille_complete[i][j]){
				return 0;
			}
		}
	}
	
	return 1;
}

/* Change la valeur de la case selectionne */
int change_case(int valeur, int c, int l, int aff_selection, int grille[9][9], int grille_complete[9][9]){
	
	/* On vrifie que le joueur a selection une case */
	if(aff_selection  == 0){
		return 0;
	} else {
		
		/* Si oui, on change la valeur */
		grille[c][l] = valeur;
		
		/* On vrifie que si la grille est termine */
		return verification_grille(grille, grille_complete); 
	}
}

/* Intialise les tableaux  chaque nouveau chargement de grille */
void nouvelle_grille(int grille[9][9], int grille_complete[9][9], int tab[9][9]){
	int i, j;
	
	for(i = 0; i < 9; i++){
		for(j = 0; j < 9; j++){
			grille[i][j] = 0;
			grille_complete[i][j] = 0;
			tab[i][j] = 0;
		}
	}
}

/* Fonction qui retourne la surface correpondant au niveau de la grille */
SDL_Surface * niveau_grille(int id){
	FILE *fichier = NULL;
	
	fichier = fopen("/rd/niveaux_grilles.txt", "rb");
	if(fichier == NULL){
		fprintf(stderr, "Imposible Acceder fichero niveaux.txt...");
		return NULL;
		
	} else {
		int i, niveau;
		char ligne[30] = {0};
	
		/* On se positionne sur la ligne correspondante  la grille */
		for(i = 0; i < id; i++){
			fgets(ligne, 100, fichier);
		}
		
		/* On lit la ligne puis on ferme le fichier */
		fscanf(fichier, "Niveau: %d", &niveau);
		fclose(fichier);
		
		sprintf(ligne, "/rd/niveau%d.png", niveau);
		return IMG_Load(ligne);
	}
}

/* Cette fonction regarde si la grille a dj t termine */
int terminer_grille(int id){
	FILE *fichier = NULL;
	
	fichier = fopen("/rd/grilles_terminees.txt", "rb");
	if(fichier == NULL){
		fprintf(stderr, "Imposible Acceder fichero grilles_terminees.txt...");
		return 0;
		
	} else {
	
		char ligne[10];
		int terminer = 0;
		char *end = NULL;
		
		while(fgets(ligne, 10, fichier)){
			
			if(id == strtol(ligne, &end, 10)){
				terminer = 1;
				break;
			}
		}
		
		fclose(fichier);		
		return terminer;
	}
}

/* Modifie le fichier des grilles termines */
void modifier_grilles_terminees(int id){
	FILE *fichier = NULL;
	
	fichier = fopen("/rd/grilles_terminees.txt", "rb");
	if(fichier == NULL){
		fprintf(stderr, "Imposible Acceder fichero grilles_terminees.txt...");
	} else {
		
		/* On ajoute le id de la grille aux grilles termines */
		fprintf(fichier, "%d\n", id);
		fclose(fichier);
	}
}

/* Cette fonction permet d'enregistrer la grille dans le fichier sauvegarde */
void sauvegarde_grille(int id, int grille[9][9]){
	
	/* On ouvre le fichier sauvegarde.txt en l'effacant */
	FILE *fichier = NULL;
	fichier = fopen("/rd/sauvegarde.txt", "rb");
	if(fichier == NULL){
		fprintf(stderr, "Imposible Acceder fichero sauvegarde.txt...");
	} else {
	
		int i, j;
		
		/* On indique le numro de la grille */
		fprintf(fichier, "id: %d ", id);
		
		/* Puis, on enregistre la grille */
		for(i = 0; i < 9; i++){
			for(j = 0; j < 9; j++){
				fprintf(fichier, "%d", grille[i][j]);
			}
		}
		
		fclose(fichier);
	}
}

void chargement_grille(int id, int grille[9][9], int grille_complete[9][9], int tab[9][9]){

	FILE *fichier_grille = NULL, *fichier_grille_complete = NULL;
	
	/* On ouvre les fichiers comportant les grilles */
	fichier_grille = fopen("/rd/grilles.txt", "rb");
	fichier_grille_complete = fopen("/rd/grilles_completes.txt", "rb");

	/* On vrifie qu'ils sont accessibles */
	if(fichier_grille == NULL || fichier_grille_complete == NULL){
		fprintf(stderr, "Imposible Acceder fichero grille...\n");
	} else {
	
		int i, j;
		char ligne[100] = {0};
		
		/* On se positionne dans le 1er fichier */
		for(i = 0; i < id; i++){
			fgets(ligne, 100, fichier_grille);
		}
		
		/* on lit la grille en question */
		fgets(ligne, 100, fichier_grille);
		for(i = 0; i < 9; i++){
			for(j = 0; j < 9; j++){
				switch(ligne[(i * 9) + j]){
					case '1': grille[i][j] = 1; tab[i][j] = 1; break;
					case '2': grille[i][j] = 2; tab[i][j] = 1; break;
					case '3': grille[i][j] = 3; tab[i][j] = 1; break;
					case '4': grille[i][j] = 4; tab[i][j] = 1; break;
					case '5': grille[i][j] = 5; tab[i][j] = 1; break;
					case '6': grille[i][j] = 6; tab[i][j] = 1; break;
					case '7': grille[i][j] = 7; tab[i][j] = 1; break;
					case '8': grille[i][j] = 8; tab[i][j] = 1; break;
					case '9': grille[i][j] = 9; tab[i][j] = 1; break;
					case '0': grille[i][j] = 0; break;
				}
			}
		}
		
		/* On ferme le fichier 1*/
		fclose(fichier_grille);
		
		/* On fat de mme pour le fichier suivant */
		for(i = 0; i < id; i++){
			fgets(ligne, 100, fichier_grille_complete);
		}
		
		fgets(ligne, 100, fichier_grille_complete);		
		for(i = 0; i < 9; i++){
			for(j = 0; j < 9; j++){
				switch(ligne[(i * 9) + j]){
					case '1': grille_complete[i][j] = 1; break;
					case '2': grille_complete[i][j] = 2; break;
					case '3': grille_complete[i][j] = 3; break;
					case '4': grille_complete[i][j] = 4; break;
					case '5': grille_complete[i][j] = 5; break;
					case '6': grille_complete[i][j] = 6; break;
					case '7': grille_complete[i][j] = 7; break;
					case '8': grille_complete[i][j] = 8; break;
					case '9': grille_complete[i][j] = 9; break;
				}
			}
		}
		
		fclose(fichier_grille_complete);
	}
}

/* Cette fonction permet de charger une sauvegarde */
int chargement_grille_sauvegarder(int grille[9][9], int grille_complete[9][9], int tab[9][9]){

	FILE *fichier_sauvegarde = NULL;
	
	/* On ouvre le fichier sauvegarde */
	fichier_sauvegarde = fopen("/rd/sauvegarde.txt", "rb");

	/* On vrifie que le fichier est accessible */
	if(fichier_sauvegarde == NULL){
		fprintf(stderr, "Imposible Acceder fichero sauvegarde...\n");
		return -1;
	} else {
		
		int i, j, id;
		char ligne[100] = {0};
		
		nouvelle_grille(grille, grille_complete, tab);
		
		if(!fscanf(fichier_sauvegarde, "id: %d %s", &id, &ligne)){
			fclose(fichier_sauvegarde);
			return -1;
		} else {
			chargement_grille(id, grille, grille_complete, tab);
			
			for(i = 0; i < 9; i++){
				for(j = 0; j < 9; j++){
					switch(ligne[(i * 9) + j]){
						case '1': grille[i][j] = 1; break;
						case '2': grille[i][j] = 2; break;
						case '3': grille[i][j] = 3; break;
						case '4': grille[i][j] = 4; break;
						case '5': grille[i][j] = 5; break;
						case '6': grille[i][j] = 6; break;
						case '7': grille[i][j] = 7; break;
						case '8': grille[i][j] = 8; break;
						case '9': grille[i][j] = 9; break;
						case '0': grille[i][j] = 0; break;
					}
				}
			}
			
			fclose(fichier_sauvegarde);
			return id;
		}
	}	
}

/* Fonction permettant de charger une nouvelle grille au hasard */
int chargement_grille_hasard(int grille[9][9], int grille_complete[9][9], int tab[9][9]){

	FILE *fichier_grille = NULL;
	
	/* On ouvre les fichiers comportant les grilles */
	fichier_grille = fopen("/rd/grilles.txt", "rb");

	/* On vrifie qu'ils sont accessibles */
	if(fichier_grille == NULL){
		fprintf(stderr, "Imposible Acceder fichero grille...\n");
		return -1;
	} else {
	
		int nbr_ligne = 0, id;
		char ligne[100] = {0};
		
		/* On intialise les tableaux  0 */
		nouvelle_grille(grille, grille_complete, tab);
			
		/* On compte le nombre de ligne */
		while(fgets(ligne, 100, fichier_grille) != NULL){
			nbr_ligne++;
		}
		
		fclose(fichier_grille);
		
		/* On choisit une au hasard */
		id = (rand() % nbr_ligne);
		chargement_grille(id, grille, grille_complete, tab);
		
		return id;
	}
}


