#include "global.h"

#include <kos.h>

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_mixer.h>
#include <SDL/SDL_dreamcast.h>



int main(int argc, char *argv[]){
	
	printf("Starting...\n");
	
	/* Initialisation + cration de la surface principale */
	SDL_Surface *ecran = NULL;
	initialisation(&ecran);

	/* Cration de la surface grille */
	SDL_Surface *img_grille = NULL;
	img_grille = IMG_Load("/rd/grille.png");	
	
	/* Cration des surfaces numros */
	SDL_Surface *b[9] = {NULL}, *n[9] = {NULL};
	chargement_chiffres(b, n);
	
	/* Image de fin */
	SDL_Surface *img_fin = NULL;
	img_fin = IMG_Load("/rd/fin.png");		
	
	/* Cration de la surface slection + terminer */
	SDL_Surface *img_selection = NULL;
	img_selection = IMG_Load("/rd/selection.png");
	SDL_SetColorKey(img_selection, SDL_SRCCOLORKEY, SDL_MapRGB(img_selection->format, 255, 255, 255));
	
	SDL_Surface *img_terminer = NULL;
	img_terminer = IMG_Load("/rd/termine.png");
	
	/* autres variables  */
	SDL_Event event;
	SDL_Rect pos_chiffre,  pos, pos_fin, pos_grille, pos_terminer;
	
	int grille[9][9], grille_complete[9][9], tab[9][9];
	int i, j, l, c, id, continuer = 1, terminer = 0, aff_selection = 0; //l=ligne,c=colonne
	
	//Dreamcast special variable to have input from the pad!!!
	int cursor=0;
	
	pos_grille.x = 0;
	pos_grille.y = 46;
	
	pos_fin.x = 46;
	pos_fin.y = 184;
	
	pos_terminer.x = 294;
	pos_terminer.y = 0;
	
	/* S'il existe une sauvegarde, on ne charge pas une nouvelle grille */
	if((id = chargement_grille_sauvegarder(grille, grille_complete, tab)) == -1){
		id = chargement_grille_hasard(grille, grille_complete, tab);
	}
	
	/* On affiche le niveau de la grille */
	SDL_BlitSurface(niveau_grille(id), NULL, ecran, NULL);
	
	/* On informe le joueur s'il l'a dj fait */
	if(terminer_grille(id) == 1){
		SDL_BlitSurface(img_terminer, NULL, ecran, &pos_terminer);
	}
	
	/* On affiche les images  */
	SDL_BlitSurface(img_grille, NULL, ecran, &pos_grille);
	
	while(continuer){
		
		/* On regarde s'il y a une slection */
		if(aff_selection == 1){
			SDL_BlitSurface(img_selection, NULL, ecran, &pos);
		}
		
		/* On affiche les chiffres */
		for(i = 0; i < 9; i++){
			for(j = 0; j < 9; j++){
				if(grille[i][j] != 0){
					pos_chiffre.x = i * 46;
					pos_chiffre.y = j * 46 + 46;
					
					if(tab[i][j] == 1){
						SDL_BlitSurface(n[(grille[i][j] - 1)], NULL, ecran, &pos_chiffre);
					} else {
						SDL_BlitSurface(b[(grille[i][j] - 1)], NULL, ecran, &pos_chiffre);
					}
				}
			}
		}
		
		/* On regarde si le jeu est termin  */
		if(terminer == 1){
			SDL_BlitSurface(img_fin, NULL, ecran, &pos_fin);
		}
			
		SDL_Flip(ecran);		
		
		/* Evnement */
		SDL_WaitEvent(&event);
		switch(event.type){
			case SDL_QUIT:	
				continuer = 0;
			break;
			
			case SDL_MOUSEBUTTONUP:
				/* On vrifie que le joueur n'a pas cliqu sur une case dj  remplie */
				//46= 46 pixels
		if(event.button.y > 46 && event.button.y < 460 && event.button.x < 414 && tab[(event.button.x / 46)][((event.button.y / 46) - 1)] == 0){
				
					/* On dfinit la ligne et la colonne */
					c = event.button.x / 46;
					l = (event.button.y / 46) - 1;
					
					pos.x = (event.button.x / 46) * 46;
					pos.y = (event.button.y / 46) * 46;
					
					/* On affiche la slection de la case */
					aff_selection = 1;
					
					/* On affiche les images  */
					SDL_BlitSurface(img_grille, NULL, ecran, &pos_grille);
					
				}				
			break;
			
			case SDL_KEYDOWN:
				
				switch(event.key.keysym.sym){
				
					case SDLK_UP: 
						if (cursor<9) cursor++;
						terminer = change_case(cursor, c, l, aff_selection, grille, grille_complete); break;
				
					case SDLK_DOWN: 
						if (cursor>0) cursor--;
						if (cursor==0) grille[c][l] = 0;
						else terminer = change_case(cursor, c, l, aff_selection, grille, grille_complete); break;
				
					case SDLK_KP1: terminer = change_case(1, c, l, aff_selection, grille, grille_complete); break;
					case SDLK_KP2: terminer = change_case(2, c, l, aff_selection, grille, grille_complete); break;
					case SDLK_KP3: terminer = change_case(3, c, l, aff_selection, grille, grille_complete); break;
					case SDLK_KP4: terminer = change_case(4, c, l, aff_selection, grille, grille_complete); break;
					case SDLK_KP5: terminer = change_case(5, c, l, aff_selection, grille, grille_complete); break;
					case SDLK_KP6: terminer = change_case(6, c, l, aff_selection, grille, grille_complete); break;
					case SDLK_KP7: terminer = change_case(7, c, l, aff_selection, grille, grille_complete); break;
					case SDLK_KP8: terminer = change_case(8, c, l, aff_selection, grille, grille_complete); break;
					case SDLK_KP9: terminer = change_case(9, c, l, aff_selection, grille, grille_complete); break;
					case SDLK_KP0: grille[c][l] = 0; break;
					
					case SDLK_ESCAPE: 
						continuer = 0;
					break;
					
					case SDLK_n:
						/* Chargement d'une nouvelle grille */
						id = chargement_grille_hasard(grille, grille_complete, tab);
						SDL_BlitSurface(niveau_grille(id), NULL, ecran, NULL);
						
						/* On informe le joueur si la grille a dj t faite */
						if(terminer_grille(id) == 1){
							SDL_BlitSurface(img_terminer, NULL, ecran, &pos_terminer);
						}
						
						/* On affiche les images  */
						SDL_BlitSurface(img_grille, NULL, ecran, &pos_grille);
						
						terminer = 0;
						aff_selection = 0;
					break;
					
					default:
					break;
				}
				
				/* Si le joueur a termin sa grille correctement, on l'enregistre dans les grilles termines */
				if(terminer == 1){
					modifier_grilles_terminees(id);
				}
				
			break;
			
			default:
			break;
		}
	}
	
	/* On effectue une sauvegarde de la grille */
	sauvegarde_grille(id, grille);
	
	/* Libration des surfaces */
	SDL_FreeSurface(img_selection);
	SDL_FreeSurface(img_grille);
	SDL_FreeSurface(img_fin);
	SDL_FreeSurface(img_terminer);

	for(i = 0; i < 9; i++){
		SDL_FreeSurface(b[i]);
		SDL_FreeSurface(n[i]);
	}
		
	return EXIT_SUCCESS;
}
