#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_mixer.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#ifdef DREAMCAST
#include <kos.h>
#include <SDL/SDL_dreamcast.h>
extern uint8 romdisk[];
KOS_INIT_ROMDISK(romdisk);
#endif

SDL_Surface *screen;

#define SCR_W 320
#define SCR_H 240

int sound_on = 1;

Mix_Chunk *eatblob_sound;
Mix_Chunk *powerpill_sound;
Mix_Chunk *dead_sound;
Mix_Chunk *eaten_sound;

/* Letters */
SDL_Surface *background;
SDL_Surface *backg;
SDL_Surface *bletters;
SDL_Surface *letters[200];
SDL_Surface *logo;

/* mgfx */
SDL_Surface *tiles[4];
SDL_Surface *dude;
SDL_Surface *ighost;
SDL_Surface *idghost;

int secx[21][21],secy[21][21],dudex,dudey,squaren[21][21],blobs,ghostx[9],ghosty[9],ghostd[9],ghost[9],gcount=0,seed,lives,level=2,ded=0,num,score=0,dcount=0,chanel=2,powerpill=0,offx,offy,lx=0,ly=380,lc=0,highscore;
Uint32 sec, cents;

FILE *file_ptr;

static char square[21][21],next;

/* Keys */
int quit = 0;
int spacebar = 0;
int b_pressed = 0;
int dl_down = 0, ul_down = 0, ur_down = 0, dr_down = 0 , q_down=0 ;


int randoon(int num)
{
	return (rand()%num+1);
}

void imageplot(SDL_Surface *image, int x, int y)
{
	SDL_Rect pos;
	pos.x = x;
	pos.y = y;
	SDL_BlitSurface(image, NULL, screen, &pos);
}

SDL_Surface *loadimage(char *name)
{
	SDL_Surface *surface;
	SDL_Surface *image;
	char path[256];

	strcpy(path, DATA_PREFIX);
	strcat(path, "/gfx/");
	strcat(path, name);
	strcat(path,".png");

	/*
	rwop=SDL_RWFromFile(path,"rb");
	surface = IMG_LoadPNG_RW( rwop );
	*/
	surface = IMG_Load(path);

	if (surface == NULL)
		fprintf(stderr, "Could not load %s", path);


	SDL_SetColorKey(surface, SDL_SRCCOLORKEY, SDL_MapRGB(surface->format, 0,0,0));
	image = SDL_DisplayFormat(surface);
	SDL_FreeSurface(surface);

	return image;
}


static int loadimages()
{
	char name[32];
	int j,i;
	SDL_Surface *Surface;
	Uint32 rmask, gmask, bmask, amask;
	 SDL_Rect rekt,peec;
	  peec.x = 0 ; peec.y = 0 ;
      rekt.x=0;rekt.y=0;rekt.w=16;rekt.h=20;

     rmask = 0x000000ff;gmask = 0x0000ff00;bmask = 0x00ff0000;amask = 0xff000000;

        bletters  = loadimage( "letters" );
        logo =loadimage("logo");
        ighost = loadimage("ghost");
        idghost = loadimage("dghost");
		dude = loadimage("dude");


	for (j = '1'; j <= '5'; j++)
	{
		sprintf(name, "%c", j);
		tiles[j-'1'] = loadimage(name);
	}
        for (i=32 ; i<123 ; i++)
    {
      Surface = SDL_CreateRGBSurface(SDL_SWSURFACE, 16, 20, 32, rmask, gmask, bmask, amask);


      letters[i] = SDL_DisplayFormat(Surface);

      SDL_FreeSurface(Surface);

      SDL_BlitSurface(bletters,&rekt,letters[i],&peec);
      SDL_SetColorKey(letters[i], SDL_SRCCOLORKEY, SDL_MapRGB(letters[i]->format, 0,0,0));
      SDL_SetAlpha(letters[i],SDL_SRCALPHA,200);
      SDL_SetAlpha(ighost,SDL_SRCALPHA,150);
      SDL_SetAlpha(idghost,SDL_SRCALPHA,150);

       rekt.y+=20;
    }
    return 1;
}

void stringplot(char strinplot[], int x,int y)
{
int i,j,str;
  j=strlen(strinplot);
  for ( i=0 ; i< j ; i++ )
  {
    str=strinplot[i];
    imageplot(letters[ str ],i*14+x,y);
  }
}

static void initandloadsounds()
{

  if ( Mix_OpenAudio(44100, AUDIO_S8, 1, 512) < 0 )
  {
	/* Can open sound so just run in quiet mode */
    sound_on=0;
  } else
  {
    char path[256];
    strcpy(path, DATA_PREFIX "/sounds/blip.wav");
    eatblob_sound = Mix_LoadWAV(path);
    strcpy(path, DATA_PREFIX "/sounds/goopy.wav");
    powerpill_sound = Mix_LoadWAV(path);
    strcpy(path, DATA_PREFIX "/sounds/cyber.wav");
    dead_sound = Mix_LoadWAV(path);
    strcpy(path, DATA_PREFIX "/sounds/got.wav");
    eaten_sound = Mix_LoadWAV(path);

  }

}

int readsix(void)
{
  int bik,bak,bok,buk,byk,bek;
  bik = fgetc( file_ptr ) ;
  bik = bik-48;
  bik = bik*100000;
  bak = fgetc( file_ptr ) ;
  bak = bak-48;
  bak = bak*10000;
  bok = fgetc( file_ptr ) ;
  bok = bok-48;
  bok = bok*1000;
  buk = fgetc( file_ptr ) ;
  buk = buk-48;
  buk = buk*100;
  byk = fgetc( file_ptr ) ;
  byk = byk-48;
  byk = byk*10;
  bek = fgetc( file_ptr ) ;
  bek = bek-48;
  return bik+bak+bok+buk+byk+bek;
}

void checkhigh(int num)
{
  char str[8];
  if (num>highscore)
  {
     file_ptr = fopen(DATA_PREFIX "/levels/highscore","rb");
  sprintf(str,"%06d",num);
  fputs(str,file_ptr);
   fclose(file_ptr);
   highscore=num;
  }
}

static void gethigh()
{
   file_ptr = fopen(DATA_PREFIX "/levels/highscore","rb");
   highscore=readsix();
   fclose(file_ptr);
}

static void info()
{
 char strng[40],scr[8],lvs[8];
 sprintf(scr,"%06d",score);
 sprintf(lvs,"%01d",lives);

        strcpy(strng, "Puntos ");
        strcat(strng, scr);
        strcat(strng, " Vidas ");
        strcat(strng, lvs);
	stringplot(strng,6+randoon(8),4+randoon(8));
}

static void floordraw()
{
	int x , y , ek;


for (x = -64 ; x<352 ; x+=64 )
{
  for (y = -32 ; y<256 ; y+=32 )
  {
	imageplot(tiles[2],x,y);
        imageplot(tiles[2],x+32,y+16);
  }
}



	for (y = 0; y < 21; y ++)
	{
		for (x = 20 ; x > 0 ; x --)
		{
			imageplot( tiles[square[x][y]-49] , secx[x][y]+offx , secy[x][y]+offy);
			
			if (dudex==x && dudey==y)
			{
				imageplot( dude , secx[dudex][dudey]+offx , secy[dudex][dudey]+offy);
			}

			for (ek = 1 ; ek<9 ; ek++ )
			{
				if (ghostx[ek]==x && ghosty[ek]==y && ghost[ek]==1 )
				{
					if (powerpill==0) {imageplot( ighost,  secx[ghostx[ek]][ghosty[ek]]+offx , secy[ghostx[ek]][ghosty[ek]]+offy);}
					if (powerpill>0)  {imageplot( idghost, secx[ghostx[ek]][ghosty[ek]]+offx , secy[ghostx[ek]][ghosty[ek]]+offy);}
				}

			}
		}
	}
}



static void GetLevel(void)
{

	int x,y,crap,inc;
       offx=-400;offy=-112;
	for ( inc=1 ; inc<9 ; inc++ )
	{
		ghost[inc]=1;ghostx[inc]=randoon(18)+1;ghosty[inc]=randoon(18)+1;ghostd[inc]=randoon(4);
	}

	dudex=10;dudey=17;

	level=randoon(4);
	if (level==1) { file_ptr = fopen(DATA_PREFIX "/levels/level1","rb"); }
	if (level==2) { file_ptr = fopen(DATA_PREFIX "/levels/level2","rb"); }
	if (level==3) { file_ptr = fopen(DATA_PREFIX "/levels/level3","rb"); }
	if (level==4) { file_ptr = fopen(DATA_PREFIX "/levels/level4","rb"); }

	blobs=0;
	for ( y=1 ; y<21 ; y++ )
	{
		for ( x=1 ; x<21 ; x++ )
		{
			next = fgetc( file_ptr ) ;
			square[x][y] = next;
			crap=(int)next;
			if (crap==49 || crap==52) { blobs++; }
			squaren[x][y]=crap;
		}
	}
	fclose(file_ptr);

	powerpill=10;
}

static void getplots(void)
{
	int  xg=21 , yg=21 , gfxx=32 , gfxy=16 , osx=304 , osy=450 , sx=304 , sy=450;
	do
	{
		do
		{
			secx[xg][yg]=sx;
			secy[xg][yg]=sy;
			sy-=gfxy;
			sx-=gfxx;
			yg--;
		}
		while ( yg>0 ) ;
		sx=osx+(xg*gfxx);
		sy=osy-(xg*gfxy);
		yg=21;
		xg--;
	}
	while (xg>0) ;
}

static void ghosts(void)
{
	int ek,byek;

	if (gcount==0)
	{
		for ( ek=1 ; ek<9 ; ek++ )
		{

			byek=ghostd[ek];
			if (ghostd[ek]==1)
			{
				if ( squaren[ghostx[ek]+1][ghosty[ek]]<50 ) { ghostx[ek]++ ;
				if ( squaren[ghostx[ek]][ghosty[ek]-1]<50 ||  squaren[ghostx[ek]][ghosty[ek]+1]<50 ) {  byek=randoon(4);   } }
				else {  byek=randoon(4);  }
			}
			if (ghostd[ek]==2)
			{
				if ( squaren[ghostx[ek]][ghosty[ek]+1]<50 ) { ghosty[ek]++ ;
				if ( squaren[ghostx[ek]+1][ghosty[ek]]<50 ||  squaren[ghostx[ek]-1][ghosty[ek]]<50) { byek=randoon(4);  } }
				else {  byek=randoon(4);  }
			}
			if (ghostd[ek]==3)
			{
				if ( squaren[ghostx[ek]-1][ghosty[ek]]<50 ) { ghostx[ek]-- ;
				if ( squaren[ghostx[ek]][ghosty[ek]-1]<50 ||  squaren[ghostx[ek]][ghosty[ek]+1]<50) { byek=randoon(4);   } }
				else { byek=randoon(4);  }
			}

			if (ghostd[ek]==4)
			{
				if ( squaren[ghostx[ek]][ghosty[ek]-1]<50 ) { ghosty[ek]-- ;
				if ( squaren[ghostx[ek]+1][ghosty[ek]]<50 ||  squaren[ghostx[ek]-1][ghosty[ek]]<50) {  byek=randoon(4); } }
				else { byek=randoon(4); }

			}
			ghostd[ek]=byek;

		}

	}
	gcount++;
	if (gcount==4){gcount=0;}

}


static void checkkeys(void)
{
	SDL_Event event;

	while (SDL_PollEvent(&event) != 0)
	{
		switch(event.type)
		{
		 
		case SDL_KEYDOWN:
			switch(event.key.keysym.sym)
			{
			case SDLK_ESCAPE: quit = 1; break;
			case SDLK_SPACE: spacebar = 1; break;
			case SDLK_b: b_pressed = 1; break;
			case SDLK_e: ul_down = 1; break;
			case SDLK_o: ur_down = 1; break;
			case SDLK_d: dr_down = 1; break;
			case SDLK_k: dl_down = 1; break;
                        case SDLK_q: q_down = 1; break;
			default: /* Stops gcc warning */ break;
			}
			break;

		case SDL_KEYUP:
			switch(event.key.keysym.sym)
			{
			case SDLK_e: ul_down = 0; break;
			case SDLK_o: ur_down = 0; break;
			case SDLK_d: dr_down = 0; break;
			case SDLK_k: dl_down = 0; break;
                        case SDLK_q: q_down = 0; break;
			default: /* Stops gcc warning */ break;
			}
			break;
	
		case SDL_QUIT:
			quit = 1;
			break;
		}
	}
	while (q_down) {
	  if (sound_on==1){ sound_on=0 ; break;}
	  if (sound_on==0){ sound_on=1 ; break;}
	}

}

static void keys(void)
{
	checkkeys();

	if (  dl_down && !ur_down && !ul_down && !dr_down && squaren[dudex-1][dudey]!=50 ) { dudex-=1; offx+=32; offy-=16;}
	if ( !dl_down &&  ur_down && !ul_down && !dr_down && squaren[dudex+1][dudey]!=50 ) { dudex+=1; offx-=32; offy+=16;}
	if ( !dl_down && !ur_down &&  ul_down && !dr_down && squaren[dudex][dudey-1]!=50 ) { dudey-=1; offy+=16;  offx+=32; }
	if ( !dl_down && !ur_down && !ul_down &&  dr_down && squaren[dudex][dudey+1]!=50 ) { dudey+=1; offy-=16;  offx-=32; }
}


int plotlogo(int bg)
{
  if (bg==0)
  {
  int x,y;
  for (x = -64 ; x<352 ; x+=64 )
{
  for (y = -32 ; y<256 ; y+=32 )
  {
	imageplot(tiles[2],x,y);
        imageplot(tiles[2],x+32,y+16);
  }
}
  }
                         imageplot(logo,lx,ly);
                         lx=randoon(SCR_W-80);
                        ly=randoon(SCR_H-40);
                        return 0;
}

static void stuff(void)
{
	if ( squaren[dudex][dudey]==49 ) {
         squaren[dudex][dudey]=0 ;
         square[dudex][dudey] = '3' ;
         blobs-- ;
         score++;

         if (sound_on) Mix_PlayChannel(1,eatblob_sound,0);

    }
	if ( squaren[dudex][dudey]==52 ) {
	   squaren[dudex][dudey]=0 ;
	   square[dudex][dudey] = '3' ;
	   blobs--;
	    score+=10 ;
	    if (powerpill>0) {powerpill+=50 ;} else {powerpill=100;}

         if (sound_on) Mix_PlayChannel(2,powerpill_sound,-1);

    }
	if (powerpill>0) {
         powerpill-- ;

         if (sound_on && powerpill == 0) Mix_HaltChannel(2);

      }

}



static void death(void)
{
	int ek;
	for (ek=1 ; ek<9 ; ek++)
	{
		if ( ghostx[ek]==dudex && ghosty[ek]==dudey && ghost[ek]==1 && powerpill==0 ) {
		  ded=1 ;
             if (sound_on) {Mix_PlayChannel(1,dead_sound,0);}
        }
		if ( ghostx[ek]==dudex && ghosty[ek]==dudey && ghost[ek]==1 && powerpill>0 ) { ghost[ek]=0 ; score+=50 ; if (sound_on) { Mix_PlayChannel(3,eaten_sound,0);}  }
            if (ghost[ek]==0 && randoon(32)==3 && powerpill==0) {ghost[ek]=1;ghostx[ek]=randoon(18)+1;ghosty[ek]=randoon(18)+1;ghostd[ek]=randoon(4);}
	}

}




int main(int argc, char *argv[])
{
	printf("Starting...\n");

	int full_screen = 0;
	int j;
       char hiscr[8];

	for (j = 1; j < argc; j++)
	{
		if (strcmp(argv[j],"-f") == 0 || strcmp(argv[j], "-fullscreen") == 0) full_screen = SDL_FULLSCREEN|SDL_DOUBLEBUF;

            else if (strcmp(argv[j],"-n") == 0 || strcmp(argv[j], "-nosound") == 0) sound_on = 0;

	}
	
	/* Initialize SDL */
	if ( SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO|SDL_INIT_JOYSTICK) < 0 ) {
		fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
		return EXIT_FAILURE;
	}

	atexit(SDL_Quit);

	if ( (screen=SDL_SetVideoMode(SCR_W,SCR_H,16,SDL_HWSURFACE|SDL_HWPALETTE|SDL_FULLSCREEN|SDL_DOUBLEBUF)) == NULL )
	{
		fprintf(stderr, "Couldn't set video mode: %s\n", SDL_GetError());
		return EXIT_FAILURE;
	}

	//SDL_WM_SetCaption("CrazeeMan 0.3",0);

	//Sets control pad of Dreamcast
	#ifdef DREAMCAST
	SDL_DC_MapKey(0,SDL_DC_START,SDLK_SPACE); 
	SDL_DC_MapKey(0,SDL_DC_LEFT,SDLK_e); 
	SDL_DC_MapKey(0,SDL_DC_RIGHT,SDLK_d);
	SDL_DC_MapKey(0,SDL_DC_UP,SDLK_o); 
	SDL_DC_MapKey(0,SDL_DC_DOWN,SDLK_k); 
	SDL_DC_MapKey(0,SDL_DC_R,SDLK_ESCAPE); //L button
	
	SDL_JoystickEventState(SDL_ENABLE);
	SDL_JoystickOpen(0); 	
	SDL_DC_EmulateMouse(SDL_bool (false));
	SDL_ShowCursor(0);
	
	//Dreamcast delay...
	SDL_Delay(50);
	SDL_Event event;
	while(SDL_PollEvent(&event))
		SDL_Delay(20);
	#endif
	
	if (!loadimages()) return EXIT_FAILURE;
    if (sound_on) initandloadsounds();


	/* Seed random number generator */
	{
		int seed = (int)time(NULL);
		srand( seed+(rand()%seed) );
	}
	j=randoon(50);
	gethigh();
	
	//WARNING!!! FIRST IS getplots, and after GetLevel because then dudex and dudey get the normal values!!!!
	getplots();
    GetLevel();
    
	do
	{

	  sprintf(hiscr,"%06d",highscore);
	  lx=40;ly=40;
		lives=3;lc=0;
		do
		{
			if (ded==0 && lc==0)
			{
			  	spacebar = 0;
			  do
			  {
			  
			    cents = SDL_GetTicks();
				if (cents < sec + 100) SDL_Delay(sec + 100 - cents);
				sec = SDL_GetTicks();
                        plotlogo(0);
			  stringplot("Pulsa Start!",70+randoon(8),180+randoon(8));
			  stringplot("Crazeeman - 0.3",50+randoon(8),20+randoon(8));
			  stringplot("Records",80+randoon(8),80+randoon(8));
			  stringplot(hiscr,110+randoon(8),110+randoon(8));

				SDL_Flip(screen);
		        checkkeys();

                        if (quit) { break; }
			  }
		         while (spacebar == 0);
			}

                        if (quit) { break; }
			ded=0;
			sec = SDL_GetTicks();
			do
			{
				cents = SDL_GetTicks();
				if (cents < sec + 100) SDL_Delay(sec + 100 - cents);
				sec = SDL_GetTicks();
				 death();
				 ghosts();
			 death();
			if (ded==0){
			 keys();
				}

				stuff();

				floordraw();
				info();
				SDL_Flip(screen);

				if (quit) { break; }
				if (ded==1) {lives--;break;}
			}
			while (blobs>0   );

			if (ded==1)
			  {
			   spacebar = 0;
                        do
                        {
                           cents = SDL_GetTicks();
				if (cents < sec + 100) SDL_Delay(sec + 100 - cents);
				sec = SDL_GetTicks();
					floordraw();

                        plotlogo(1);
                        	info();
			    stringplot("Vida Perdida!",80+randoon(8),150+randoon(8));

                        if (lives==0) { stringplot("Juego Terminado!",80+randoon(8),200+randoon(8));}

                SDL_Flip(screen);
                checkkeys();
                if (quit) { break; }
                        }
                while (spacebar == 0);

                if (lives==0) GetLevel();
                 dudex=10;dudey=17;powerpill=10;offx=-400;offy=-112;
			}
			else
			{
			  lc=1;
                        spacebar = 0;
                        do
                        {
                           cents = SDL_GetTicks();
			if (cents < sec + 100) SDL_Delay(sec + 100 - cents);
			sec = SDL_GetTicks();
                        plotlogo(0);
                        info();
			    stringplot("Nivel Superado!",60+randoon(8),150+randoon(8));
			    checkkeys();
			    SDL_Flip(screen);
                            if (quit==1) { break; }
                        }
                        while (spacebar == 0);
                        	GetLevel();
			}

			if (quit==1) { break; }
		}

		while (lives > 0);
		 checkhigh(score);
		score=0;lives=3;ded=0;
                if (quit) { break; }
	}
	while (quit == 0);

	//Close the game
    Mix_CloseAudio();
	SDL_Quit(); //missing!

	return EXIT_SUCCESS;
}
