
#ifndef __CONSTANTS_H__
#define __CONSTANTS_H__

#include <iostream>

#include <SDL/SDL.h>

//#define __DEBUG__		// Print out Some Debug Information

#define HIGHNAME ".hEierscore"

const std::string NAME	 	= "Sarah-Maries Eierjagd";
const std::string VERSION 	= "0.1";
const std::string COPYRIGHT 	= "Copyright (c) 2005, Patrick Gerdsmeier <patrick@gerdsmeier.net>";
const std::string WEBSITE 	= "http://www.gerdsmeier.net";

const double PI = 3.141592;

// SCREEN
const int SCREENWIDTH		= 640; 
const int SCREENHEIGHT 		= 480;
const int MAXPOSITIONS		= 6;
const int TICK_INTERVAL_GAME 	= 25; 
const int ANIMFRAME		= 3;
const int MAXEGGS		= 3;
const int MAXMISSES		= 3;
const int MISSEDHEIGHT		= 370;
const int CATCHHEIGHTTOP	= 292;
const int CATCHHEIGHTBOT	= 322;
const int MAXLEVEL		= 6;
const int HIGHSCORE		= 0;

// KEYBOARD. I think this Keyboard functions are Ok:
const int KEY_QUIT 		= SDLK_ESCAPE;
const int KEY_NEWGAME	 	= SDLK_F1;
const int KEY_SCREENSHOT 	= SDLK_F12;
const int KEY_LEFT		= SDLK_LEFT;
const int KEY_RIGHT		= SDLK_RIGHT;

extern void verbose( std::string info );

#define RANDOM( max, min ) ( ( max + 1 - min ) * ( rand() / ( RAND_MAX + 1.0 ) ) + min )

#define MAX( a, b ) ( ( a > b ) ? a : b )

#define SCREAM(t) std::cout << t << std::endl << std::flush;


#endif

