
#ifndef __GRAPHICS_H__
#define __GRAPHICS_H__

#include <SDL/SDL.h>

#include "constants.h"

extern SDL_Surface* MYSDLSCREEN;

/******************************************************************************************
 *
 * Font
 *
 * Font is a class that manages a BMP (Background=0xff00ff) Font.
 *
 ******************************************************************************************/
class Font
{
public:
	Font();
	
	~Font();
	
	void print( int x, int y, std::string txt, int alpha=255 ); 

	int getLineHeight() const;

	int getWidth( std::string txt );
	
private:
	SDL_Surface *font_image;
};

/******************************************************************************************
 *
 * Sprite
 *
 * Sprite manages a BMP (Background=0xff00ff) as a screen sprite
 * If Constructed with frames-parameter, Sprite uses serialised
 * Pictures as Anim with size: Sprite-size / frames;
 *
 ******************************************************************************************/
class Sprite
{
public:	
	Sprite( char* filename, int frames=1 );

	~Sprite();

	bool is_onLastFrame();
	
	int getWidth();
		
	void setFramerate( int rate );

	void setRepeatmode( bool mode );

	void resetFrames();
	
 	void setPos( int x, int y );

	void setAlpha( int a );
		
	void draw();
	
	static void putpixel( int x, int y, Uint32 pixel, SDL_Surface *screen=MYSDLSCREEN );

private:
	SDL_Surface *sprite_image;
	SDL_Rect sprite_rect, rect;
	int x, y, width, height, alpha;
	bool repeat_mode;
	int frames, 
		actual_frame,
		frame_delay,
		frame_rate;
};

#endif

