#include <kos/fs.h>
#include <sys/stat.h>

int mkdir(const char *name,mode_t mode)
{
	return -1;
}

int access(const char *name,int mode)
{
	int fd = fs_open(name,O_RDONLY);
	if (fd==0) return -1;
	fs_close(fd);
	return 0;
}

int _stat(const char *name,struct stat *st)
{
	int fd;
	int size;

	memset(st,0,sizeof(*st));

	fd = fs_open(name,O_RDONLY);
	if (fd) {
		size = fs_total(fd);
		fs_close(fd);
		st->st_mode = S_IFREG;
		st->st_size = size;
		return 0;
	}
	fd = fs_open(name,O_DIR);
	if (fd) {
		fs_close(fd);
		st->st_mode = S_IFDIR;
		return 0;
	}
	return -1;
}
