
#ifndef _SYSTEM_H_
#define _SYSTEM_H_

/* Input devices */
/* SD - Added none, changed numbers */
#define MAX_DEVICES         (8)     /* Unsure of maximum */
#define DEVICE_NONE         (0)     /* No device connected */
#define DEVICE_2BUTTON      (1)     /* 2-button gamepad */
#define DEVICE_3BUTTON      (2)     /* 3-button gamepad */
#define DEVICE_6BUTTON      (3)     /* 6-button gamepad */


/* Input bitmasks */
#define INPUT_MODE      (0x00000800)
#if defined(_arch_dreamcast)
#include "kos.h"
#define INPUT_Z         CONT_Z
#define INPUT_Y         CONT_Y
#define INPUT_X         CONT_C
#define INPUT_START     CONT_START
#define INPUT_C         CONT_B
#define INPUT_B         CONT_A
#define INPUT_A         CONT_X
#define INPUT_LEFT      CONT_DPAD_LEFT
#define INPUT_RIGHT     CONT_DPAD_RIGHT
#define INPUT_DOWN      CONT_DPAD_DOWN
#define INPUT_UP        CONT_DPAD_UP
#else
#define INPUT_Z         (0x00000400)
#define INPUT_Y         (0x00000200)
#define INPUT_X         (0x00000100)
#define INPUT_START     (0x00000080)
#define INPUT_C         (0x00000040)
#define INPUT_B         (0x00000020)
#define INPUT_A         (0x00000010)
#define INPUT_LEFT      (0x00000008)
#define INPUT_RIGHT     (0x00000004)
#define INPUT_DOWN      (0x00000002)
#define INPUT_UP        (0x00000001)
#endif

typedef struct
{
    uint8 *data;        /* Bitmap data */
    //int width;          /* Bitmap width (32+512+32) */
    //int height;         /* Bitmap height (256) */
    //int depth;          /* Color depth (8 bits) */
    //int pitch;          /* Width of bitmap in bytes */
    //int granularity;    /* Size of each pixel in bytes */
    //int remap;          /* 1= Translate pixel data */
    struct {
        int x;          /* X offset of viewport within bitmap */
        int y;          /* Y offset of viewport within bitmap */
        int w;          /* Width of viewport */
        int h;          /* Height of viewport */
        int ow;         /* Previous width of viewport */
        int oh;         /* Previous height of viewport */
    }viewport;
}t_bitmap;  

typedef struct
{
    uint8 dev[MAX_DEVICES];     /* Can be any of the DEVICE_* values */
    uint32 pad[MAX_DEVICES];    /* Can be any of the INPUT_* bitmasks */
    uint32 system;              /* Can be any of the SYSTEM_* bitmasks */
}t_input;

typedef struct
{
    int sample_rate;    /* Sample rate (8000-44100) */
    int enabled;        /* 1= sound emulation is enabled */
    int buffer_size;    /* Size of sound buffer (in bytes) */
    int16 *buffer[2];   /* Signed 16-bit stereo sound data */
    struct {
        int16 *buffer[2];
    } fm;
    struct {
        int curStage;
        int lastStage;
        int16 *buffer;
    } dac;
    struct {
        int16 *buffer;
    } psg;
}t_snd;

/* Global variables */
extern t_bitmap bitmap;
extern t_input input;
extern t_snd snd;

/* Function prototypes */
void system_init(int cpu68k_type, int xvdp);
int system_frame();
void system_reset(void);
void system_shutdown(void);
int audio_init(int rate);
void audio_update(void);

#endif /* _SYSTEM_H_ */

