#ifndef WT_FONT_H
#define WT_FONT_H

#define FNT_MAX_IMAGES 6

#define VID_SCREEN_W 640
#define VID_SCREEN_H 480
#define view_rot     0
#define view_scale   1
#define view_x       0
#define view_y       0
#define view_mid_x   320
#define view_mid_y   240
#define view_rcos    1
#define view_rsin    0

typedef struct fnt_info               /* font structure */
{
  int            *pos_array;                  /* array of character positions */
  pvr_poly_hdr_t  hdr_array[FNT_MAX_IMAGES];  /* array of pvr headers */
  pvr_ptr_t       txr_array[FNT_MAX_IMAGES];  /* array of texture pointers */
  int             height;                     /* height of font */
  uint32          txr_height;                 /* texture height */
  uint32          txr_width;                  /* texture width */
}
fnt_info_t;

typedef struct fnt_obj                /* Font (string) object */
{
  char  *text;
  int8   display;
  int    outline_wid;
  uint32 outline_colour;
}
fnt_obj_t;

#define FNT_MAX_OBJECTS 10

#define FNT_MAX_FONTS     10
#define FNT_CENTRAL       -999999      /* special value meaning 'centre' text */
#define FNT_DEF_FILETYPE  "fnt"         /* filetype for tile description file */

                                      /* RET: void */
void fnt_init(void);                  /* void */

void fnt_term(void);

                                      /* RET: 1 for success, 0 for failure */
int fnt_load(char *font_name,         /* name of .wtf file */
             fnt_info_t *font);       /* font structure to populate */

                                      /* RET: void */
void fnt_unload(fnt_info_t *font);    /* font to unload */

void fnt_write_simple(fnt_info_t *font,
                      char *string,
                      int x,
                      int y,
                      float z,
                      float scale,
                      float fade,
                      uint32 colour);

                                       /* RET: void */
void fnt_write(fnt_info_t *font,       /* font to use */
               char *string,           /* string to display */
               int x,                  /* x-position (CENTRAL) */
               int y,                  /* y-position (CENTRAL) */
               int max_x,              /* max x-position, 0 for no limit */
               float z,                /* z-position */
               int rotation,
               float scale,            /* scaling factor */
               float fade,             /* fade 0-1 */
               uint32 colour,          /* r << 16 | g << 8 | b */
               int *wid_out,           /* output width, 0 for not needed */
               int *hgt_out,           /* output height, 0 for not needed */
               int8 display,           /* actually display? 0 = no, +ve = yes */
               int outline_wid,        /* width of outline for display=3/4 */
               uint32 outline_colour); /* colour of the outline */

int fnt_render(fnt_info_t *font,
               char *text,
               int32 map_x,
               int32 map_y,
               float z_order,
               int rotation,
               float scale,
               float fade,
               uint32 colour,
               int8 display,
               int outline_wid,
               uint32 outline_colour);

int fnt_render_obj(uint32 info,
                   uint32 unused,    
                   int32 map_x,          /* map x position (centre of string) */
                   int32 map_y,          /* map y position (centre of string) */
                   float z_order,                   /* z-value for the string */
                   int32 rotation,                     /* rotation in degrees */
                   float scale,                           /* scale the object */
                   float fade,                            /* colour intensity */
                   uint32 colour);                    /* r << 16 | g << 8 | b */
                   
uint32 fnt_obj_create_str(char *string);         /* string string description */

void fnt_obj_free(uint32 info);                         /* string information */

uint32 fnt_inst_create(uint32 info);                    /* string information */

void fnt_inst_free(uint32 info);               /* string instance information */
#endif
