#!/bin/bash
# Simple shell script to generate a romlist

# Clear existing data
rm -f data/gpwt/data/roms.txt
rm -f data/gpwt/data/roms/*.zip
rm -f ../roms.iso

for fn in games/*.bin ; do
	bn="`basename "$fn" .bin`"
	crc=`crc32 "$fn"`
	zn="data/gpwt/data/roms/$crc.zip"

	zip -9 "$zn" "$fn"
	echo "$crc.zip $bn" >> data/gpwt/data/roms.txt
done

# Create new CD image
mkisofs -o ../roms.iso data
