#ifndef _SRAM_H_
#define _SRAM_H_

extern uint8 cart_ram[0x10000];
extern uint32 sram_start;
extern uint32 sram_end;
extern int sram_present;
extern int sram_active;

void sram_init();	// Check if there's any SRAM, try to load it (called on ROM load)
void sram_reset();	// Reset the SRAM (called on Genesis reset)
void sram_on();		// Activate SRAM area
void sram_off();	// Deactivate SRAM area
void sram_load();	// Loads SRAM
void sram_save();	// Saves SRAM

// SRAM file I/O
int sram_read_open();
void sram_read_close();
uint8 sram_read_uint8();
uint16 sram_read_uint16();
uint32 sram_read_uint32();

int sram_write_open();
void sram_write_close();
void sram_write_uint8(uint8 value);
void sram_write_uint16(uint16 value);
void sram_write_uint32(uint32 value);

#endif // _SRAM_H_
