#include <kos.h>
#include "menu.h"
#include "font.h"
#include "utils.h"
#include "main.h"

int sound_qualities[] = {0,1,-1}; //4800,9600,14400,19200,-1};
int cpu_68k_options[] = {0,1,-1};
int render_options[] = {0,1,-1};
int fps_options[] = {0,1,-1};
int mode_options[] = {0x00, 0x01, 0x81, 0xC1, -1};
char *mode_name[] = {"Auto", "Jap", "USA", "Eur"};

//Quzar- This was an idea I had a long time ago, where you use the flashrom setting to make the menu multi-lingual. It's mostly a novelty

/* Flashrom Language Numbers = Jap: 0 Eng:1 Ger:2 Frn:3 Spa:4 Ita:5 */
unsigned char	Buttons_str[6][16]=	{"Buttons"	, "Buttons"	, "Tasten"	, "Boutons"	, "Botones"		, "Tasti"	};
unsigned char	Sound_str[6][16]=	{"Sound"	, "Sound"	, "Ton"	, "Bruit"	, "Sonido"	, "Suono"	};
//unsigned char	Video_str[6][16]=	{"Video"	, "Video"	, "Bildschirm"	, "Video"	, "Video"	, "Video"	};	//Decided against this since they're all the same =P
//unsigned char	 On_str[6][16]=	{"On"	, "On"	, "On"	, "On"	, "Encendido"	, "Sopra"	};		//If someone provides nice short versions of these, they could be implemented
//unsigned char	Off_str[6][16]=	{"Off"	, "Off"	, "Off"	, "Off"	, "Apagado"		, "Disinserito"	};
unsigned char	lang_idx  =1;

extern int force_mode;

static int oldbutt = -1;
static char* file_selection = 0;
maple_device_t	*dev;
cont_state_t	  *state;

typedef struct rom_info
{
  char *name;
  char *filename;
}
rom_info_t;

static rom_info_t *roms = 0;
static int total_roms = 0; 
static int rom_scroll = 0;
static int rom_sel    = 0;
static int sq_sel     = 1;
static int cpu_sel    = 1;	
static int render_sel = 1;
static int mode_sel   = 0;
static int fps_sel	  = 0;

#define ROM_MAX 22

char *files_browser();

/* Configurable options */
options_t dc_options =
{
	0,						  /* Frameskip */
	487,	          /* M68k clock speed */
	228,     			  /* Z80 clock speed */
  SE_DEFAULT,     /* sound enabled */
  FPS_DEFAULT,    /* fps display */
  PAD_DEFAULT,	  /* pad type	*/
  CPU68K_DEFAULT, /* Type of M68K CPU to use 0 = C68K, 1 = FAME */
  RENDER_DEFAULT
};

#if defined(USE_ROMDISK)
extern uint8 romdisk[];
KOS_INIT_ROMDISK(romdisk);
#endif

extern void dc_init();
extern void test_exec(char *filename);

extern fnt_info_t font;

void read_roms(void)
{
  FILE *fp = 0;

  char name[256];

  sprintf(name,"%s/roms.txt",data_dir);

  if ((fp = fopen(name,"rb")))
  {
    char *t;
    char line[1024];

    while (fgets(line,sizeof(line),fp))
    {
		roms = (rom_info_t *)realloc(roms,(total_roms+1)*sizeof(rom_info_t));

		if(strchr(line, '|') != NULL)	//Quzar - New format for ROMS.txt allows for whitespace
		{
			if ((t=strtok(line,"|")))
			{
				roms[total_roms].filename = strdup(t);
				roms[total_roms].name = strdup(t+(strlen(t)+1));
				total_roms++;
			}
		}
		else{

			if ((t=strtok(line,UTL_WHITESPACE)))
			{
				roms[total_roms].filename = strdup(t);
				roms[total_roms].name = strdup(t+(strlen(t)+1));
				total_roms++;
			}
		}
    }

    fclose(fp);
  }
  else
  {
	  printf("No roms.txt found, searching for roms manually...\n");	//Quzar- should implement this at some point...
  }

}

char *rom_human_name = NULL;

char *files_browser() 
{
	int		           i;
						
  int repeat  = 0;

	pvr_set_bg_color(0, 0, 0);

	while(1)
	{
		pvr_wait_ready();
		pvr_scene_begin();

		pvr_list_begin(PVR_LIST_TR_POLY);

    fnt_write_simple(&font,
                     "Here's all your games:",
                     24, 24,
                     14,
                     0.48,
                     1,
                     0xFFFF00);

    for(i=0; i+rom_scroll < total_roms && i < ROM_MAX; i++)
    {
      fnt_write_simple(&font,
                       roms[i+rom_scroll].name,
                       40, 66+i*18,
                       14,
                       0.5,
                       ((i+rom_scroll)==rom_sel)?1:0.5,
                       0xFFFFFF);    
    }

		pvr_list_finish();

		pvr_scene_finish();

		/* Get controller state */
		state = (cont_state_t *)maple_dev_status(dev);
		if(!state)
			continue;

    if (oldbutt && state->buttons == oldbutt)
      repeat++;
    else
      repeat=0;

    if (repeat>20 || state->buttons != oldbutt)
    {
      if ((state->buttons & CONT_A) &&
          (state->buttons & CONT_B) &&
          (state->buttons & CONT_X))
        break;

      if(state->buttons & CONT_DPAD_UP)
        rom_sel--;
      else if(state->buttons & CONT_DPAD_DOWN)
        rom_sel++;
      else if (state->buttons & CONT_DPAD_RIGHT)
      {
        rom_scroll += ROM_MAX/2;

        if (rom_scroll > total_roms - ROM_MAX)
          rom_scroll = total_roms-ROM_MAX;

        rom_sel = rom_scroll + ROM_MAX/2;
      }
      else if (state->buttons & CONT_DPAD_LEFT)
      {
        rom_scroll -= ROM_MAX/2;

        if (rom_scroll < 0)
          rom_scroll = 0;

        rom_sel = rom_scroll + ROM_MAX/2;
      }

      if(rom_sel<0)
        rom_sel=0;
      else if (rom_sel>=total_roms)
        rom_sel=total_roms-1;

      if (rom_sel> (rom_scroll+ROM_MAX-1))
        rom_scroll++;
      if (rom_sel<rom_scroll)
        rom_scroll--;

      if ((state->buttons & CONT_B) && !(oldbutt & CONT_B))
      	return 0;

      if ((state->buttons & CONT_START) && !(oldbutt & CONT_START))
      {
        char game_path[256];

	sprintf(game_path, "%s/roms/%s", data_dir, roms[rom_sel].filename);
	rom_human_name = roms[rom_sel].name;

        /* -------------------------------------------------- */
        /* So, when we come back, we think we're in repeat!!! */
        /* -------------------------------------------------- */
        oldbutt = CONT_C | CONT_Z | CONT_START;

        return(strdup(game_path));
      }


      oldbutt = state->buttons;
    }
	}

  return 0;
}

int main_menu()
{

	int		           i;
						
	int repeat  = 0;

	pvr_set_bg_color(0, 0, 0);

	while(1)
	{
		pvr_wait_ready();
		pvr_scene_begin();

		pvr_list_begin(PVR_LIST_TR_POLY);


		fnt_write_simple(&font,
                     "A for Roms",
                     24, 24,
                     14,
                     0.48,
                     1,
                     0xFFFF00);

		fnt_write_simple(&font,
                     "B for Options",
                     48, 48,
                     14,
                     0.48,
                     1,
                     0xFFFF00);


		pvr_list_finish();

		pvr_scene_finish();

		/* Get controller state */
		state = (cont_state_t *)maple_dev_status(dev);
		if(!state)
			continue;

		if (oldbutt && state->buttons == oldbutt)
			repeat++;
		else
			repeat=0;

		if (repeat>20 || state->buttons != oldbutt)
		{
			if ((state->buttons & CONT_START) && !(oldbutt & CONT_START) &&
			(state->buttons & CONT_DPAD_LEFT) && (state->buttons & CONT_B))
				return 0;
	  
			if ((state->buttons & CONT_A) &&
			(state->buttons & CONT_B) &&
			(state->buttons & CONT_X))
				return 0;

			if ((state->buttons & CONT_X) && !(oldbutt & CONT_X))
				return 4;

			if ((state->buttons & CONT_Y) && !(oldbutt & CONT_Y))
				return 5;

			if ((state->buttons & CONT_B) && !(oldbutt & CONT_B))
				return 2;

			if ((state->buttons & CONT_A) && !(oldbutt & CONT_A))
				return 1;

			if ((state->buttons & CONT_C) && !(oldbutt & CONT_C))
				return 3;

			if ((state->buttons & CONT_Z) && !(oldbutt & CONT_Z))
				return 6;

			//if ((state->buttons & CONT_START) && !(oldbutt & CONT_START))		return 7;


			oldbutt = state->buttons;
		} 
	}

	return 0;
}

void options_menu() 
{

	int		           i;
						
  char browse_txt[80] = "";
  int repeat  = 0;

	pvr_set_bg_color(0, 0, 0);

	while(1)
	{
		pvr_wait_ready();
		pvr_scene_begin();

		pvr_list_begin(PVR_LIST_TR_POLY);

    sprintf(browse_txt, "[%s (X): %s] [%s (Y): %s] [CPU (B): %s] \n[Video (A): %s] [Mode (L): %s] [FPS (R): %s]",
			  Buttons_str[lang_idx],
              (dc_options.pad_type?"6":"3"),
			  Sound_str[lang_idx],
              (dc_options.sound_enabled ? "On" : "Off"),
              (dc_options.cpu68k_type == 0 ? "C68K" : "FAME"),
              (dc_options.render_type ? "HW" : "SW"),
              mode_name[mode_sel],
			  (dc_options.fps_display? "On" : "Off"));

    fnt_write_simple(&font,
                     browse_txt,
                     24, 24,
                     14,
                     0.48,
                     1,
                     0xFFFF00);

		pvr_list_finish();

		pvr_scene_finish();

		/* Get controller state */
		state = (cont_state_t *)maple_dev_status(dev);
		if(!state)
			continue;

    if (state->ltrig > 128)
      state->buttons |= CONT_C;

    if (state->rtrig > 128)
      state->buttons |= CONT_Z;

    if (oldbutt && state->buttons == oldbutt)
      repeat++;
    else
      repeat=0;

    if (repeat>20 || state->buttons != oldbutt)
    {
      if ((state->buttons & CONT_A) &&
          (state->buttons & CONT_B) &&
          (state->buttons & CONT_X))
        break;

      if ((state->buttons & CONT_X) && !(oldbutt & CONT_X))
        dc_options.pad_type = !dc_options.pad_type;

      if ((state->buttons & CONT_Y) && !(oldbutt & CONT_Y))
      {
        sq_sel++;

        REDO_SQ_SEL:

        dc_options.sound_enabled = sound_qualities[sq_sel];

        if (dc_options.sound_enabled == -1)
        {
          sq_sel = 0;
          goto REDO_SQ_SEL;
        }

        if (dc_options.sound_enabled)
          dc_options.z80_clock = 228;
        else
          dc_options.z80_clock = 25;
      }

      if ((state->buttons & CONT_B) && !(oldbutt & CONT_B))
      {
        cpu_sel++;

        REDO_CPU_SEL:

        dc_options.cpu68k_type = cpu_68k_options[cpu_sel];

        if (dc_options.cpu68k_type == -1)
        {
          cpu_sel = 0;
          goto REDO_CPU_SEL;
        }
      }

      if ((state->buttons & CONT_A) && !(oldbutt & CONT_A))
      {
        render_sel++;

        REDO_RENDER_SEL:

        dc_options.render_type = render_options[render_sel];

        if (dc_options.render_type == -1)
        {
          render_sel = 0;
          goto REDO_RENDER_SEL;
        }
      }

      if ((state->buttons & CONT_C) && !(oldbutt & CONT_C))
      {
        mode_sel++;

        REDO_MODE_SEL:

        force_mode = mode_options[mode_sel];

        if (force_mode == -1)
        {
          mode_sel = 0;
          goto REDO_MODE_SEL;
        }
      }

	  if ((state->buttons & CONT_Z) && !(oldbutt & CONT_Z))	//Quzar - fps is now on the last button
      {
        fps_sel++;

        REDO_FPS_SEL:

        dc_options.fps_display = fps_options[fps_sel];

        if (dc_options.fps_display == -1)
        {
          fps_sel = 0;
          goto REDO_FPS_SEL;
        }
      }

      if ((state->buttons & CONT_START) && !(oldbutt & CONT_START))
      	return;
	  

      oldbutt = state->buttons;
    }
	}

  return 0;
}

int main(int argc, char *argv[])
{
	dc_init();

	flashrom_syscfg_t * flashrom_config = NULL;	//Quzar- Set the language
	flashrom_get_syscfg(flashrom_config);
	lang_idx = flashrom_config->language;

  read_roms();

	int menu_return = 0;
	int old_menu_return = 0;

  for(;;)
  {
	if(!dev)
		/* If no controller, find a controller */
		dev = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
	menu_return = main_menu();
	//if (menu_return == old_menu_return)		continue;
	//old_menu_return = menu_return;
	
	switch(menu_return){
		
		case 0:
			return 0;
		break;

		case 1:		
		{
			file_selection = files_browser();
			if (file_selection == 0)
				break;
			else{
				test_exec(file_selection);

				free(file_selection);
				file_selection = 0;
			}			
		}
		break;

		case 2:
			options_menu();
		break;

		default:
			printf("something else");
		break;
	}



  }
  dc_shutdown();
  return 0;

}
/*
char *old_files_browser() 
{
	maple_device_t	*dev;
	cont_state_t	  *state;
	int		           i;
						
  char browse_txt[80] = "";
  int repeat  = 0;

	pvr_set_bg_color(0, 0, 0);

	while(1)
	{
		pvr_wait_ready();
		pvr_scene_begin();

		pvr_list_begin(PVR_LIST_TR_POLY);

    sprintf(browse_txt, "[%s (X): %s] [%s (Y): %s] [CPU (B): %s] \n[Video (A): %s] [Mode (L): %s] [FPS (R): %s]",
			  Buttons_str[lang_idx],
              (dc_options.pad_type?"6":"3"),
			  Sound_str[lang_idx],
              (dc_options.sound_enabled ? "On" : "Off"),
              (dc_options.cpu68k_type == 0 ? "C68K" : "FAME"),
              (dc_options.render_type ? "HW" : "SW"),
              mode_name[mode_sel],
			  (dc_options.fps_display? "On" : "Off"));

    fnt_write_simple(&font,
                     browse_txt,
                     24, 24,
                     14,
                     0.48,
                     1,
                     0xFFFF00);

    for(i=0; i+rom_scroll < total_roms && i < ROM_MAX; i++)
    {
      fnt_write_simple(&font,
                       roms[i+rom_scroll].name,
                       40, 66+i*18,
                       14,
                       0.5,
                       ((i+rom_scroll)==rom_sel)?1:0.5,
                       0xFFFFFF);    
    }

		pvr_list_finish();

		pvr_scene_finish();

		// Find a controller //
		dev = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);

		// Get controller state //
		state = (cont_state_t *)maple_dev_status(dev);
		if(!state)
			continue;

    if (state->ltrig > 128)
      state->buttons |= CONT_C;

    if (state->rtrig > 128)
      state->buttons |= CONT_Z;

    if (oldbutt && state->buttons == oldbutt)
      repeat++;
    else
      repeat=0;

    if (repeat>20 || state->buttons != oldbutt)
    {
      if ((state->buttons & CONT_A) &&
          (state->buttons & CONT_B) &&
          (state->buttons & CONT_X))
        break;

      if(state->buttons & CONT_DPAD_UP)
        rom_sel--;
      else if(state->buttons & CONT_DPAD_DOWN)
        rom_sel++;
      else if (state->buttons & CONT_DPAD_RIGHT)
      {
        rom_scroll += ROM_MAX/2;

        if (rom_scroll > total_roms - ROM_MAX)
          rom_scroll = total_roms-ROM_MAX;

        rom_sel = rom_scroll + ROM_MAX/2;
      }
      else if (state->buttons & CONT_DPAD_LEFT)
      {
        rom_scroll -= ROM_MAX/2;

        if (rom_scroll < 0)
          rom_scroll = 0;

        rom_sel = rom_scroll + ROM_MAX/2;
      }

      if(rom_sel<0)
        rom_sel=0;
      else if (rom_sel>=total_roms)
        rom_sel=total_roms-1;

      if (rom_sel> (rom_scroll+ROM_MAX-1))
        rom_scroll++;
      if (rom_sel<rom_scroll)
        rom_scroll--;

      if ((state->buttons & CONT_X) && !(oldbutt & CONT_X))
        dc_options.pad_type = !dc_options.pad_type;

      if ((state->buttons & CONT_Y) && !(oldbutt & CONT_Y))
      {
        sq_sel++;

        REDO_SQ_SEL:

        dc_options.sound_enabled = sound_qualities[sq_sel];

        if (dc_options.sound_enabled == -1)
        {
          sq_sel = 0;
          goto REDO_SQ_SEL;
        }

        if (dc_options.sound_enabled)
          dc_options.z80_clock = 228;
        else
          dc_options.z80_clock = 25;
      }

      if ((state->buttons & CONT_B) && !(oldbutt & CONT_B))
      {
        cpu_sel++;

        REDO_CPU_SEL:

        dc_options.cpu68k_type = cpu_68k_options[cpu_sel];

        if (dc_options.cpu68k_type == -1)
        {
          cpu_sel = 0;
          goto REDO_CPU_SEL;
        }
      }

      if ((state->buttons & CONT_A) && !(oldbutt & CONT_A))
      {
        render_sel++;

        REDO_RENDER_SEL:

        dc_options.render_type = render_options[render_sel];

        if (dc_options.render_type == -1)
        {
          render_sel = 0;
          goto REDO_RENDER_SEL;
        }
      }

      if ((state->buttons & CONT_C) && !(oldbutt & CONT_C))
      {
        mode_sel++;

        REDO_MODE_SEL:

        force_mode = mode_options[mode_sel];

        if (force_mode == -1)
        {
          mode_sel = 0;
          goto REDO_MODE_SEL;
        }
      }

	  if ((state->buttons & CONT_Z) && !(oldbutt & CONT_Z))	//Quzar - fps is now on the last button
      {
        fps_sel++;

        REDO_FPS_SEL:

        dc_options.fps_display = fps_options[fps_sel];

        if (dc_options.fps_display == -1)
        {
          fps_sel = 0;
          goto REDO_FPS_SEL;
        }
      }


      if ((state->buttons & CONT_START) && !(oldbutt & CONT_START))
      {
        char game_path[256];

	sprintf(game_path, "%s/roms/%s", data_dir, roms[rom_sel].filename);
	rom_human_name = roms[rom_sel].name;

        // -------------------------------------------------- //
        // So, when we come back, we think we're in repeat!!! //
        // -------------------------------------------------- //
        oldbutt = CONT_C | CONT_Z | CONT_START;

        return(strdup(game_path));
      }

	  if ((state->buttons & CONT_START) && !(oldbutt & CONT_START) &&	//Quzar- Button mash to exit.
		  (state->buttons & CONT_A) && (state->buttons & CONT_B) && 
		  (state->buttons & CONT_X)&& (state->buttons & CONT_Y))
      {
		return 0;
	  }

      oldbutt = state->buttons;
    }
	}

  return 0;
}
*/
