/*
 *  SDL-Fighter is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  SDL-Fighter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>
#include <SDL/SDL_image.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <sys/stat.h>
#include <math.h>
#include <time.h>
#include "BFont.h"

#define MESSAGE_TIMEOUT 2750
#define MAX_MESSAGE_LEN 32
#define MAX_LVL_DES_ELEMENTS 15

typedef struct 
{
	int time_delay[MAX_LVL_DES_ELEMENTS];
	int pack_type[MAX_LVL_DES_ELEMENTS];
}lvl_des;

typedef struct {
	char msg[MAX_MESSAGE_LEN];
	int time;
}message;

typedef struct{
	int x;
	int y;
}rect_xy;

struct object{
	int type;
	SDL_Surface *image;
	rect_xy pos1;
	rect_xy pos2;
	float velocity;
	float angle;
	int weapon;
	int tols;
	int energy;
	int shield;
	char remove;
	int direction; // kierunek 0 w lewo | 1 w prawo | 2 prosto
	void (*MoveOBJ)(struct object *obj);
};

struct explosion{
	rect_xy pos1; // Position
	int startx; // Start position X
	int starty; // Start position Y
	int frame; // Current frame
	int tolfc; // Time of last frame change
	int ttw; // Time to wait (delay between 2 frames)
};

#define VERSION   0.5
#define CVERSION "0.5"

#define Paste SDL_LowerBlit
#define MAX_RADIUS 	110

#define NUM_BOOM_FRAMES	10
#define NUM_LEVELS	5
#define NUM_TRACKS	7
#define NUM_CHUNKS	4
#define NUM_IMAGES	17

#define EN_SIZE sizeof(struct object)
#define EX_SIZE sizeof(struct explosion)

#define BULLET			0
#define MISSILE			1
#define PLASMA_BULLET		2
#define SHIP_BULLET		3
#define SHIP_MISSILE		4
#define SHIP_PLASMA_BULLET	5
#define ENEMY			6
#define LITTLE_ENEMY		7
#define PACK_LIFE		8
#define PACK_ENERGY		9
#define PACK_SHIELD		10
#define PACK_SURPRISE   	11
#define PACK_FAST_SHOOTING	12
#define BOSS			13

#define CANNON			0	
#define MISSILE_LAUNCHER	1
#define PLASMAGUN		2

#define BOSS_ENERGY	8000

#ifdef WIN32
#define main_dir ""
#define pixmaps_dir "pixmaps\\"
#define sounds_dir "sounds\\"
#define explosion_dir "pixmaps\\explosion\\"
#endif

#ifdef DREAMCAST
#define main_dir "/rd/"
#define sounds_dir main_dir "/sounds/"
#define pixmaps_dir main_dir "/pixmaps/"
#define explosion_dir main_dir "/pixmaps/explosion/"
#else
#define main_dir "/usr/local/share/games/SDL-Fighter"
#define sounds_dir main_dir "/sounds/"
#define pixmaps_dir main_dir "/pixmaps/"
#define explosion_dir main_dir "/pixmaps/explosion/"
#endif

#define MAX_FPS_FRAME_COUNT 20
#define DEFAULT_SHIPS 3
#define DEFAULT_BULLETS 1000
#define DEFAULT_MISSILES 50
#define DEFAULT_PLASMAS 30

#define ENEMY_TIME_DELAY 800
#define LITTLE_ENEMY_TIME_DELAY 6000
#define LITTLE_ENEMY_SHOT_TIME_DELAY 350
#define BOSS_SHOT_TIME_DELAY 175

#define MAX_PACKS 5
#define MAX_ENEMIES 24
#define MAX_BULLETS 48
#define MAX_EXPLOSIONS 16

#define MAX_SCROLLS 25
#define MAX_BONUS_KILL_INTERVAL 600

#define BULLET_IMG 0
#define MISSILE_IMG 1
#define PLASMA_BULLET_IMG 13

#define MAX_LITTLES 4
#define MAX_MESSAGES 4

#define MAX_GAMMA 10.0f
#define MIN_GAMMA 0.0f

#ifdef true
#undef true
#endif
#ifdef false
#undef false
#endif

#define true 1
#define false 0

extern float gamma_val;
extern int fawless_victory;
extern int fawless_victory_msg_time;
extern char eweapons[NUM_LEVELS][2];
extern int espeed[NUM_LEVELS];
extern int SCREEN_X,SCREEN_Y;
extern SDL_Event event;
extern int tol_add_ship,
	tol_add_pack,
	tol_add_littles,
	num_littles;
extern int t1,
	t2,
	dt,
	dt2,
	ships, // Number of lives
	score, // Score
	BGPos,
	current_level,
	num_scrolls,
	is_boss,
	game_finished,
	credits,
	credits_pos,
	help,
	godmode,
	godtime,
	quit,           // End?
	current_music,  // Current music
	paused_music,   // Paused music?
	paused_game,    // Paused game?
	repeat_music,   // Repeat music
	music_volume,  // Music volume
	chunk_volume; // Chunk volume

extern int player_ammo[3];
extern int last_enemy_kill[2];
extern int last_kill_time_id;
extern int littles_radius;
extern lvl_des packs_info;
extern int cur_pack_info;
// Fps
extern float fps,shooting_spd;
// enemies
extern struct object enemies[MAX_ENEMIES];
extern int num_enemies;
//enemy bullets
extern struct object ebullets[MAX_BULLETS];
extern int num_ebullets;
//packs
extern struct object packs[MAX_PACKS];
extern int num_packs;
//ship bullets
extern struct object ship_bullets[MAX_BULLETS];
extern int num_ship_bullets;
//boss
extern struct object boss;
//player ship
extern struct object ship;
// Explosions
extern struct explosion explosions[MAX_EXPLOSIONS];
extern int num_explos;
// All messages
extern message messages[MAX_MESSAGES];
extern char home_dir[256];
// Number of messages
extern int num_messages;

extern SDL_Surface *screen; // Screen
extern SDL_Surface *icon, // Icon
	*bgfull,
	*bgimage,
	*energy,
	*shield,
	*benergy;

extern SDL_Surface *frame[NUM_BOOM_FRAMES]; // Explosion frames
extern SDL_Surface *obj[NUM_IMAGES]; // Images
extern SDL_Rect BGRect,BGSrc; 
//status of energy and shield
extern SDL_Rect epos, //energy pos
	esrc, //energy src
	spos, //shield pos
	ssrc, //shield src
	bpos, //boss energy pos
	bsrc; //boss energy src
// Font
extern BFont_Info *font;
extern Mix_Music *music[NUM_TRACKS]; //tracks
extern Mix_Chunk *chunk[NUM_CHUNKS]; //chunks
extern Uint8 *keys;
extern char *tracks[NUM_TRACKS*2];

// Functions for player ship movement
void ShipMoveUp(void);
void ShipMoveDown(void);
void ShipMoveRight(void);
void ShipMoveLeft(void);
// Add object
void AddOBJ(int x,int y,int type,int *size, int max, struct object *objects);
void AddEnemy(int type); // Add enemy
void AddEnemyBullet(int x, int y, int type); // Add enemy bullet
void AddShipBullet(int type); // Add ship bullet
void AddPack(int type); // Add pack
void SetShip(void); // Set parameters for players ship
void SetBoss(void); // Set parameters for boss
// Add explosion
void AddExplosion(int x,int y);
void AddExplosionAtObj(struct object obj); // Add explosion at object position
void AddExplosionAtBoss(void); // Add explosions at boss position
void AddLittles(void); // Add little ships
// Delete object
void DeleteOBJ(int which, int *size, struct object *objects);
void DeleteEnemy(int which); // Delete enemy
void DeleteEnemyBullet(int which); // Delete enemy bullet
void DeleteShipBullet(int which); // Delete (players) ship bullet
void DeletePack(int which); // Delete pack
void DeleteExplosion(int which); // Delete explosion
// Check collision between obj_a and obj_b
inline int Collide(struct object obj_a, struct object obj_b);
// Check collision for enemy
void CheckEnemyCollisions(int i);
// Check collision for boss
void CheckBossCollisions(void);
// Check collision for players ship
void CheckShipCollisions(void);
// Check screen edges
void CheckScreenEdges(void);
// Draw object
inline void DrawOBJ(struct object obj);
void DrawExplosions(void); // Draw explosions
// Move down the object
inline void MoveDown(struct object *obj);
inline void MoveUp(struct object *obj); // Move up 

inline void MoveRandomDown(struct object *obj);
inline void MoveRandomUp(struct object *obj);
// Move Boss
void MoveBOSS(struct object *obj);
// Move little ship
void MoveLittle(struct object *obj);
// Rand function
int rand_ab(int a, int b);
// Load explosion frames
void LoadFrames();
// Load image to the SDL surface
SDL_Surface *LoadImage(char *filename);
void SetBGAlpha(SDL_Surface *img);
void CheckSurface(SDL_Surface *img, const char *fmt, ...);
void ErrorExit(const char *fmt, ...);
void ShowText();
// Load info about level
void LoadLvlDes(lvl_des *sp);
//void SaveLvlDes(lvl_des sp);
// Adds message
void AddMessage(const char *fmt, ...);
// Deletes message
void DelMessage(int which);
// Shows messages
void ShowMessages(void);
// writes to log
void WriteLog(const char *fmt, ...);
// Sets next track and plays it
void NextMUS();
// Ne game
void NewGame();

void clearevents(void);

