/*
 *  SDL-Fighter is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  SDL-Fighter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "main.h"

char *weapons[] = {"Cannon","Missile launcher","Plasma gun"};

/* NAME:	ShowShipShield
 * DESCRIPTION:	
 */
void ShowShipShield(void)
{
	int i;
	ssrc.y = ship.shield-1;
	ssrc.x = 0;
	ssrc.w = shield->w;
	ssrc.h = 1;
	spos.y = SCREEN_Y - FontHeight(font)*2;
	for(i=0;i<ship.shield;i++)
	{
		SDL_BlitSurface(shield,&ssrc,screen,&spos); //show players ship shield
		spos.y--;
	}
}

/* NAME:	ShowShipEnergy
 * DESCRIPTION:	
 */
void ShowShipEnergy(void)
{
	int i;
        esrc.y = ship.energy-1;
        esrc.x = 0;
        esrc.w = energy->w;
        esrc.h = 1;
        epos.y = SCREEN_Y - FontHeight(font)*2;
        for(i=0;i<ship.energy;i++)
        {
                SDL_BlitSurface(energy,&esrc,screen,&epos); //show players ship energy
                epos.y--;
        }
}

/* NAME:	ShowBossEnergy
 * DESCRIPTION:	
 */
void ShowBossEnergy(void)
{
	int i;
	bsrc.y = 0;
	bsrc.x = (int)((float)boss.energy/(float)BOSS_ENERGY*100)-1;
	bsrc.h = benergy->h;
	bsrc.w = 1;
	bpos.x = SCREEN_X/2-bsrc.x/2;
	for(i=0;i<bsrc.x+1;i++)	
	{
		SDL_BlitSurface(benergy,&bsrc,screen,&bpos); //show boss energy
		bpos.x ++;
	}
}

/* NAME:	ShowText
 * DESCRIPTION:	Shows some text
 */
void ShowText()
{
	if(!credits)
	{
		if(!repeat_music)
			RightPrintStringFont  (screen, font, SCREEN_Y-FontHeight(font)*2, "Track %d | Energy: %d",current_music+1,ship.energy);
		else
			RightPrintStringFont  (screen, font, SCREEN_Y-FontHeight(font)*2, "Repeat | Track %d | Energy: %d",current_music+1,ship.energy);
		RightPrintStringFont  (screen, font, SCREEN_Y-FontHeight(font), "%s",tracks[current_music*2]);

		//title
		CenteredPrintStringFont  (screen, font, 0, "SDL-Fighter by Radoslaw Gniazdowski");
		//level
		RightPrintStringFont  (screen,font,FontHeight(font),"Level: %d/%d | %.1f",current_level,NUM_LEVELS,fps);

		ShowMessages();

		if(!ships && !help)
	       	{
#ifdef WIN32
			CenteredPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font), "You are dead");
#else
			CenteredPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font), "You are dead");
#endif
			CenteredPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 , "Hit ENTER to restart");
			CenteredPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 + FontHeight(font), "or ESCAPE to exit");
		}
		// Fawless victory message
		if(fawless_victory_msg_time && SDL_GetTicks() - fawless_victory_msg_time < MESSAGE_TIMEOUT)
	       	{
			CenteredPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font), "FLAWLESS VICTORY!!!");
			CenteredPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2			  , "You have killed BOSS");
			CenteredPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 + FontHeight(font), "without losing any ship");
		}
		else if(game_finished && !help)
	       	{
			CenteredPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font)*2, "Game over!");
#ifdef WIN32
			CenteredPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font), "You've won!");
#else
			CenteredPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font), "You've won!");
#endif
			CenteredPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 , "Hit ENTER to restart");
			CenteredPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 + FontHeight(font), "or ESCAPE to exit");
		}
		// help
		if(help)
	       	{
			LeftPrintStringFont   (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font)*5 ,"F1");
			RightPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font)*5 ,"toggle fullscreen");	
			LeftPrintStringFont   (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font)*4 ,"F2");
			RightPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font)*4 ,"help");
			LeftPrintStringFont   (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font)*3 ,"F3");
			RightPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font)*3 ,"credits");
			LeftPrintStringFont   (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font)*2 ,"p");
			RightPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font)*2 ,"pause game");
			LeftPrintStringFont   (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font)   ,"num+/num-");
			RightPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 - FontHeight(font)   ,"music volume");
			LeftPrintStringFont   (screen, font, SCREEN_Y/2 - FontHeight(font)/2		       ,"u/j");
			RightPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2		       ,"SFX volume");
			LeftPrintStringFont   (screen, font, SCREEN_Y/2 - FontHeight(font)/2 + FontHeight(font)   ,"z/x/c/v/b");
			RightPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 + FontHeight(font)   ,"previous music/play/pause music/stop/next music");
			LeftPrintStringFont   (screen, font, SCREEN_Y/2 - FontHeight(font)/2 + FontHeight(font)*2 ,"Arrows");
			RightPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 + FontHeight(font)*2 ,"move");
			LeftPrintStringFont   (screen, font, SCREEN_Y/2 - FontHeight(font)/2 + FontHeight(font)*3 ,"Space");
			RightPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 + FontHeight(font)*3 ,"change weapon");
			LeftPrintStringFont   (screen, font, SCREEN_Y/2 - FontHeight(font)/2 + FontHeight(font)*4 ,"CTRL");
			RightPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 + FontHeight(font)*4 ,"fire");
			LeftPrintStringFont   (screen, font, SCREEN_Y/2 - FontHeight(font)/2 + FontHeight(font)*5 ,"[/]");
			RightPrintStringFont  (screen, font, SCREEN_Y/2 - FontHeight(font)/2 + FontHeight(font)*5 ,"decrease/increase gamma");
		}
		ShowShipShield();
		ShowShipEnergy();
		if(is_boss)
			ShowBossEnergy();

		PrintStringFont  (screen, font, 0, SCREEN_Y-FontHeight(font)*2, "Shield: %d | Weapon: %s",ship.shield, weapons[ship.weapon]);
		PrintStringFont  (screen, font, 0, SCREEN_Y-FontHeight(font), "Score: %d | Ships: %d | Ammo: %d",score, ships, player_ammo[ship.weapon]);
	}
       	else 
	{
		credits_pos-=(int)(ceil(0.08*dt2));
		if(credits_pos < -(FontHeight(font)*16))
			credits_pos = SCREEN_Y;

		CenteredPrintStringFont  (screen, font, credits_pos                      , "SDL-Fighter");
		CenteredPrintStringFont  (screen, font, credits_pos + FontHeight(font)*1 , "Version "CVERSION);
		CenteredPrintStringFont  (screen, font, credits_pos + FontHeight(font)*3 , "Main code and images");
		CenteredPrintStringFont  (screen, font, credits_pos + FontHeight(font)*4 , "Radoslaw Gniazdowski");
		CenteredPrintStringFont  (screen, font, credits_pos + FontHeight(font)*6 , "BFont library");
		CenteredPrintStringFont  (screen, font, credits_pos + FontHeight(font)*7 , "Diego Billi");
		CenteredPrintStringFont  (screen, font, credits_pos + FontHeight(font)*9 , "Beta tester and ideas");
		CenteredPrintStringFont  (screen, font, credits_pos + FontHeight(font)*10, "Mariusz Gniazdowski");
		CenteredPrintStringFont  (screen, font, credits_pos + FontHeight(font)*12, "Music");
		CenteredPrintStringFont  (screen, font, credits_pos + FontHeight(font)*13, "Mantronix - Phenomena Enigma");
		CenteredPrintStringFont  (screen, font, credits_pos + FontHeight(font)*14, "Mekkannik/Btl - 10 Minutes Trash");
		CenteredPrintStringFont  (screen, font, credits_pos + FontHeight(font)*15, "Moby - Dragonsfunk and Knulla Kuk");
	}
}
