/*
 *  SDL-Fighter is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  SDL-Fighter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "main.h"

/* NAME:	LoadLvlDes
 * DESCRIPTION:	
 */
void LoadLvlDes(lvl_des *sp)
{
	FILE *fp;
	char tmp[256];

	//Changed for Dreamcast version:
	sprintf(tmp, "/rd/lvl_des");

	fp = fopen(tmp, "rb");
	if(!fp)
		ErrorExit("Unable to open file: %s", tmp);
	fread(sp,1,sizeof(lvl_des),fp);
	fclose(fp);
}

/* NAME:	SaveLvlDes
 * DESCRIPTION:	Sa
 *
 void SaveLvlDes(lvl_des sp)
 {
 FILE *fp;
 char tmp[256];

#ifndef win32
sprintf(tmp, "%s/.SDL-Fighter/lvl_des", home_dir);
#else
sprintf(tmp, "lvl_des");
#endif

fp = fopen(tmp, "wb");
fwrite(&sp,1,sizeof(lvl_des),fp);
fclose(fp);
}
*/

/* NAME:	AddMessage
 * DESCRIPTION:	Adds message
 */
void AddMessage(const char *fmt, ...)
{
	char buff[64];
	va_list args;

	if(num_messages != MAX_MESSAGES)
	{
		va_start(args,fmt);
		vsprintf(buff,fmt,args);
		va_end(args);

		messages[num_messages].time = SDL_GetTicks();
		sprintf(messages[num_messages].msg,"%s",buff);
		num_messages++;
	}
}

/* NAME:	DelMessage
 * DESCRIPTION:	Delemessage
 */
void DelMessage(int which)
{
	if(num_messages)
	{
		memmove(messages+which, messages+which+1,(num_messages-which)*sizeof(message));
		num_messages--;
	}
}

/* NAME:	ShowMessages
 * DESCRIPTION:	Show all messages
 */
void ShowMessages(void)
{
	int i;
	for(i=0; i<num_messages; i++)
	{
		LeftPrintStringFont  (screen,font,FontHeight(font)*(i+1),"%s",messages[i].msg);
		if(SDL_GetTicks() - messages[i].time > MESSAGE_TIMEOUT)
			DelMessage(i);
	}
}

/* NAME:	WriteLog
 * DESCRIPTION:	Writes message to log
 */
void WriteLog(const char *fmt, ...)
{
	char buff[256];
	char tmp[256];
	FILE *log;
	va_list args;

	va_start(args,fmt);
	vsprintf(buff,fmt,args);
	va_end(args);

#ifndef win32
	sprintf(tmp, "%s/.SDL-Fighter/log.log", home_dir);
#else
	sprintf(tmp, "log.log");
#endif
	if((log = fopen(tmp,"a")) == NULL)
	{
		printf("Unable to open log\n");
		return;
	}

	fprintf(log,"%s\n",buff);
	fclose(log);
}

void ErrorExit(const char *fmt, ...)
{
	char buff[256];
	va_list args;

	va_start(args,fmt);
	vsprintf(buff,fmt,args);
	va_end(args);

	WriteLog("%s\n",buff);
	fprintf(stderr,"%s\n",buff);

	SDL_Quit();
	exit(0);
}
/* NAME:	CheckSurface
 * DESCRIPTION:	Checks SDL surface - if NULL, writes error and quits the program
 */
void CheckSurface(SDL_Surface *img, const char *fmt, ...)
{
	char buff[256];
	va_list args;

	va_start(args,fmt);
	vsprintf(buff,fmt,args);
	va_end(args);

	if(img == NULL)
		ErrorExit(buff);
}

void DelAll(void)
{
	int i;
	for(i=0; i<num_enemies; i++)
		enemies[i].energy = false;
	for(i=0; i<num_ebullets; i++)
		ebullets[i].energy = false;
	for(i=0; i<num_ship_bullets; i++)
		ship_bullets[i].energy = false;
	for(i=0; i<num_packs; i++)
		packs[i].energy = false;
}

/* NAME:	NewGame
 * DESCRIPTION:	Sets new game (delete objects, reset score, etc.)
 */
void NewGame()
{
	DelAll();
	if(is_boss)
		AddExplosionAtBoss();
	ships = DEFAULT_SHIPS;
	score = 0;
	is_boss = false;
	fawless_victory = true;
	current_level = 1;
	cur_pack_info = 0;
	num_scrolls = 0;
	SetShip();
	game_finished = false;
}

void NextMUS()
{
	if(!quit && !repeat_music)
	{
		current_music++;
		if(current_music == NUM_TRACKS)
			current_music = 0;

		Mix_PlayMusic(music[current_music],1);
	}
	if(!quit && repeat_music)
		Mix_PlayMusic(music[current_music],1);
	Mix_VolumeMusic(music_volume);
}
