/*
 *  SDL-Fighter is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  SDL-Fighter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "main.h"

void add_kill_time(void)
{
	last_kill_time_id++;
	if(last_kill_time_id == 2)
		last_kill_time_id = 0;
	last_enemy_kill[last_kill_time_id] = SDL_GetTicks();
}

void boss_dead(void)
{
	add_kill_time();
	score+=10000;
	is_boss = false;
	AddMessage("---=== Level %d completed ===---",current_level);
	if(current_level == NUM_LEVELS)
		game_finished = true;
	current_level++;
	if(current_level > NUM_LEVELS)
		current_level = NUM_LEVELS;
	AddExplosionAtBoss();
	boss.energy = 0;
	if(fawless_victory)
	{
		fawless_victory_msg_time = SDL_GetTicks();
		score+=5000;
	}
}

/* NAME:	CheckScreenEdges
 * DESCRIPTION:	Checks object position
 */
void CheckScreenEdges(void)
{
	int i;
	for(i=0;i<num_enemies;i++)
		if(enemies[i].pos1.y > SCREEN_Y)
			enemies[i].remove=1;
		else 
		{
			if(enemies[i].pos1.x < 0-enemies[i].image->w)
				enemies[i].direction = 1;
			else if(enemies[i].pos1.x > SCREEN_X)
				enemies[i].direction = 0;
		}
	for(i=0;i<num_ebullets;i++)
		if(ebullets[i].pos1.y > SCREEN_Y)
			ebullets[i].remove = true;
	for(i=0;i<num_packs;i++)
		if(packs[i].pos1.y > SCREEN_Y)
			packs[i].remove = true;
	for(i=0;i<num_ship_bullets;i++)
		if(ship_bullets[i].pos1.y <= 15)
			ship_bullets[i].remove = true;
}

/* NAME:	Collide
 * DESCRIPTION:	Checks for collision between obj_a and obj_b
 */
inline int Collide(struct object obj_a, struct object obj_b)
{
	if(obj_a.pos1.x + obj_a.image->w < obj_b.pos1.x ||
			obj_a.pos1.x > obj_b.pos1.x + obj_b.image->w ||
			obj_a.pos1.y > obj_b.pos1.y + obj_b.image->h ||
			obj_a.pos1.y + obj_a.image->h < obj_b.pos1.y)
		return 0;

	return 1;
}

/* NAME:	CheckEnemyCollisions
 * DESCRIPTION:	Checks collision for object
 */
void CheckEnemyCollisions(int i)
{
	int j;
	for(j=0;j<num_ship_bullets;j++)
	{
		if(Collide(enemies[i],ship_bullets[j]))
		{
			// Po wykryciu kolizji odejmowana jest energia
			// Wrogowie nie posiadaj pancerza
			if(ship_bullets[j].type == SHIP_BULLET)
				enemies[i].energy -= 25;
			if(ship_bullets[j].type == SHIP_MISSILE)
				enemies[i].energy -= 50;
			if(ship_bullets[j].type == SHIP_PLASMA_BULLET)
				enemies[i].energy -= 100;

			if(enemies[i].energy <= 0)
			{
				add_kill_time();
				if(enemies[i].type == ENEMY)
					score+=200;
				else if(enemies[i].type == LITTLE_ENEMY)
					score+=100;
				enemies[i].energy = 0;
			}
			ship_bullets[j].energy -= 20;
			if(ship_bullets[j].energy <= 0)
				ship_bullets[j].energy = 0;
			return;
		}
	}
}

void CheckBossCollisions(void)
{
	int j;
	for(j=0;j<num_ship_bullets;j++)
	{
		if(Collide(boss,ship_bullets[j]))
		{
			if(ship_bullets[j].type == SHIP_BULLET)
				boss.energy -= 25;
			if(ship_bullets[j].type == SHIP_MISSILE)
				boss.energy -= 50;
			if(ship_bullets[j].type == SHIP_PLASMA_BULLET)
				boss.energy -= 100;

			if(boss.energy <= 0)
				boss_dead();
			ship_bullets[j].energy -= 20;
			if(ship_bullets[j].energy <= 0)
				ship_bullets[j].energy = 0;
			return;
		}
	}
}

void ShipDecrementLife(int how_much)
{
	if(ships)
	{
		ship.shield -= how_much;
		if(ship.shield < 0)
		{
			ship.energy += ship.shield;
			ship.shield = 0;
		}
		if(ship.energy <= 0)
		{
			godtime = SDL_GetTicks();
			godmode = true;
			ship.energy = 0;
			ships--;
			if(is_boss)
				fawless_victory = false;
			AddExplosionAtObj(ship);
		}
	}	
}

/* NAME:	CheckShipCollisions
 * DESCRIPTION:	Checks collisions for player ship
 */
void CheckShipCollisions(void)
{
	int j;
	if(SDL_GetTicks() - godtime > 5000 && godmode)
		godmode = false;
	if(!godmode && ships)
	{
		if(is_boss && Collide(boss, ship))
		{
			boss.energy -= 100;
			ShipDecrementLife(100);
			if(boss.energy <= 0)
				boss_dead();
			return;
		}

		for(j=0; j<num_enemies; j++)
		{
			if(Collide(ship,enemies[j]))
			{
				ShipDecrementLife(30);
				enemies[j].energy -= 100;
				if(enemies[j].energy < 0)
					enemies[j].energy = 0;
			}
		}
		for(j=0; j<num_ebullets; j++)
		{
			if(Collide(ship,ebullets[j]))
			{
				if(ebullets[j].type == BULLET)
					ShipDecrementLife(1);
				else if(ebullets[j].type == MISSILE)
					ShipDecrementLife(6);
				else if(ebullets[j].type == PLASMA_BULLET)
					ShipDecrementLife(10);
				ebullets[j].energy = 0;
			}
		}
	}
	for(j=0;j<num_packs;j++)
	{
		if(Collide(ship,packs[j]) && ships)
		{
			if(packs[j].type == PACK_LIFE)
			{
				ships++;
				AddMessage("--== Ship Pack ==--");
			}
			else if(packs[j].type == PACK_ENERGY)
			{
				ship.energy+=70;
				AddMessage("--== Energy Pack ==--");
			}
			else if(packs[j].type == PACK_SHIELD)
			{
				ship.shield+=70;
				AddMessage("--== Shield Pack ==--");
			}
			else if(packs[j].type == PACK_FAST_SHOOTING)
			{
				shooting_spd+=0.2f;
				if(shooting_spd > 1.5f)
					shooting_spd = 1.5f;
				AddMessage("--== Fast shooting Pack ==--");
			}
			else if(packs[j].type == PACK_SURPRISE)
			{
				switch(rand_ab(1,5))
				{
					case 1:
						ship.energy += 70;
						AddMessage("--== Energy Pack ==--");
						break;
					case 2:
						ship.shield += 70;
						AddMessage("--== Shield Pack ==--");
						break;
					case 3:
						player_ammo[0]+=250;
						AddMessage("--== Bullets Pack ==--");
						break;
					case 4:
						player_ammo[1]+=50;
						AddMessage("--== Missiles Pack ==--");
						break;
					case 5:
						player_ammo[2]+=30;
						AddMessage("--== Plasma ammo Pack ==--");
						break;
				}
			}
			if(ship.energy > 100)
				ship.energy = 100;
			if(ship.shield > 100)
				ship.shield = 100;
			packs[j].energy = 0;
		}
	}
}

